/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.block.IElectricityStorage;
import universalelectricity.core.block.IVoltage;

public class UniversalElectricityUtils {
    public static boolean isValidTarget(TileEntity target) {
        return target instanceof IVoltage || target instanceof IElectricityStorage || target instanceof IConductor;
    }

    public static Map getDetails(World world, Object obj, boolean additional) {
        HashMap<String, Double> response = new HashMap<String, Double>();
        if (additional) {
            if (obj instanceof IVoltage) {
                response.put("Voltage", ((IVoltage)obj).getVoltage());
            }
            if (obj instanceof IElectricityStorage) {
                double joules = ((IElectricityStorage)obj).getJoules();
                double maxJoules = ((IElectricityStorage)obj).getMaxJoules();
                response.put("Stored", joules);
                response.put("MaxStorage", maxJoules);
                if (maxJoules > 0.0) {
                    double percent = 100.0 / maxJoules * joules;
                    percent = Math.max(Math.min(percent, 100.0), 0.0);
                    response.put("PowerPercentFull", percent);
                }
            }
            if (obj instanceof IConductor) {
                response.put("ConductorCapacity", ((IConductor)obj).getCurrentCapcity());
                response.put("Resistance", ((IConductor)obj).getResistance());
            }
        }
        return response;
    }
}

