/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.util;

import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import openccsensors.OpenCCSensors;
import openccsensors.common.CommonProxy;
import openccsensors.common.util.OCSLog;

public class LanguageUtils {
    public static void setupLanguages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            InputStream input = CommonProxy.class.getResourceAsStream(String.format("%s/languages.txt", OpenCCSensors.LANGUAGE_PATH));
            if (input == null) {
                OCSLog.warn("Cannot load languages.txt. Names may not be displayed correctly.", new Object[0]);
                return;
            }
            BufferedReader var2 = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            String var3 = var2.readLine();
            while (var3 != null) {
                arrayList.add(var3);
                var3 = var2.readLine();
            }
        }
        catch (IOException var5) {
            OCSLog.warn("Cannot load languages.txt. Names may not be displayed correctly. Stack trace follows.", new Object[0]);
            var5.printStackTrace();
            return;
        }
        for (String langString : arrayList) {
            URL url = CommonProxy.class.getResource(String.format("%s/%s.lang", OpenCCSensors.LANGUAGE_PATH, langString));
            if (url == null) {
                OCSLog.warn("Skipping loading of language %s - language file not found.", langString);
                continue;
            }
            LanguageRegistry.instance().loadLocalization(url, langString, false);
        }
    }
}

