/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import openccsensors.common.util.InventoryUtils;

public class EntityUtils {
    public static HashMap getEntities(World world, Vec3 sensorPos, double radius, Class filter) {
        HashMap<String, Entity> map = new HashMap<String, Entity>();
        int dChunk = (int)Math.ceil(radius / 16.0);
        int x = (int)sensorPos.field_72450_a;
        int y = (int)sensorPos.field_72448_b;
        int z = (int)sensorPos.field_72449_c;
        for (int dx = -dChunk; dx <= dChunk; ++dx) {
            for (int dz = -dChunk; dz <= dChunk; ++dz) {
                Chunk chunk = world.func_72938_d(x + 16 * dx, z + 16 * dz);
                for (List subchunk : chunk.field_76645_j) {
                    for (Entity entity : subchunk) {
                        Vec3 livingPos = Vec3.func_72443_a((double)(entity.field_70165_t + 0.5), (double)(entity.field_70163_u + 0.5), (double)(entity.field_70161_v + 0.5));
                        if (!(sensorPos.func_72438_d(livingPos) <= radius) || !filter.isAssignableFrom(entity.getClass())) continue;
                        String targetName = entity instanceof EntityPlayer ? entity.func_70023_ak() : entity.func_70023_ak() + entity.field_70157_k;
                        targetName = targetName.replaceAll("\\s", "");
                        map.put(targetName, entity);
                    }
                }
            }
        }
        return map;
    }

    public static HashMap livingToMap(EntityLiving living, Vec3 sensorPos, boolean additional) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Double> position = new HashMap<String, Double>();
        position.put("X", living.field_70165_t - sensorPos.field_72450_a);
        position.put("Y", living.field_70163_u - sensorPos.field_72448_b);
        position.put("Z", living.field_70161_v - sensorPos.field_72449_c);
        map.put("Position", position);
        map.put("Name", living instanceof EntityPlayer ? "Player" : living.func_70023_ak());
        map.put("RawName", living.getClass().getName());
        if (additional) {
            map.put("HeldItem", InventoryUtils.itemstackToMap(living.func_70694_bm()));
            HashMap<String, HashMap> armour = new HashMap<String, HashMap>();
            armour.put("Boots", InventoryUtils.itemstackToMap(living.func_71124_b(1)));
            armour.put("Leggings", InventoryUtils.itemstackToMap(living.func_71124_b(2)));
            armour.put("Chestplate", InventoryUtils.itemstackToMap(living.func_71124_b(3)));
            armour.put("Helmet", InventoryUtils.itemstackToMap(living.func_71124_b(4)));
            map.put("Armour", armour);
            map.put("Health", living.func_70630_aN());
            map.put("IsAirborne", living.field_70160_al);
            map.put("IsJumping", living.field_70703_bu);
            map.put("IsBlocking", living.func_70632_aY());
            map.put("IsBurning", living.func_70027_ad());
            map.put("IsAlive", living.func_70089_S());
            map.put("IsInWater", living.func_70090_H());
            map.put("IsOnLadder", living.func_70617_f_());
            map.put("IsSleeping", living.func_70608_bn());
            map.put("IsRiding", living.func_70115_ae());
            map.put("IsSneaking", living.func_70093_af());
            map.put("IsSprinting", living.func_70051_ag());
            map.put("IsWet", living.func_70026_G());
            map.put("IsChild", living.func_70631_g_());
            map.put("IsHome", living.func_70611_aB());
            map.put("Yaw", Float.valueOf(living.field_70177_z));
            map.put("Pitch", Float.valueOf(living.field_70125_A));
            map.put("YawHead", Float.valueOf(living.field_70759_as));
            HashMap<Integer, String> potionEffects = new HashMap<Integer, String>();
            Collection effects = living.func_70651_bq();
            int count = 1;
            for (PotionEffect effect : effects) {
                potionEffects.put(count, effect.func_76453_d());
                ++count;
            }
            map.put("PotionEffects", potionEffects);
        }
        if (living instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)living;
            map.put("FoodLevel", player.func_71024_bL().func_75116_a());
            map.put("Gamemode", player.field_71075_bZ.field_75098_d);
            if (additional) {
                map.put("Username", player.field_71092_bJ);
            }
            map.put("Inventory", InventoryUtils.invToMap((IInventory)player.field_71071_by));
        }
        return map;
    }
}

