/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.util;

import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import openccsensors.common.util.InventoryUtils;

public class AppliedEnergisticsUtils {
    private static final String ME_WIRELESS_CLASS = "appeng.me.tile.TileWireless";

    public static boolean isValidTarget(Object target) {
        return target != null && target.getClass().getName() == ME_WIRELESS_CLASS;
    }

    public static HashMap getTileDetails(Object obj, boolean additional) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (!(obj instanceof TileEntity)) {
            return response;
        }
        TileEntity aeWirelessAPtileEntity = (TileEntity)obj;
        response.put("Powered", false);
        IGridMachine aeMachine = (IGridMachine)aeWirelessAPtileEntity;
        IGridInterface gi = aeMachine.getGrid();
        if (gi != null && gi.isValid() && aeMachine.isPowered()) {
            IMEInventoryHandler imivh = gi.getFullCellArray();
            response.put("Powered", true);
            response.put("FreeTypes", (int)imivh.remainingItemTypes());
            response.put("FreeCount", (int)imivh.remainingItemCount());
            response.put("FreeBytes", (int)imivh.freeBytes());
            response.put("UsedBytes", (int)imivh.usedBytes());
            long totalBytes = imivh.freeBytes() + imivh.usedBytes();
            double percent = 100.0 / (double)totalBytes * (double)imivh.usedBytes();
            percent = Math.max(Math.min(percent, 100.0), 0.0);
            response.put("InventoryPercentFull", percent);
            if (additional) {
                List list = imivh.getAvailableItems().getItems();
                int totalCount = 0;
                HashMap<Integer, HashMap> stacks = new HashMap<Integer, HashMap>();
                for (int i = 0; i < list.size(); ++i) {
                    ItemStack items = (ItemStack)list.get(i);
                    stacks.put(i + 1, InventoryUtils.itemstackToMap(items));
                    Integer count = items.field_77994_a;
                    totalCount += count.intValue();
                }
                response.put("UsedTypes", list.size());
                response.put("UsedCount", totalCount);
                response.put("Slots", stacks);
                response.put("CanHoldNewItems", imivh.canHoldNewItem());
                response.put("Priority", imivh.getPriority());
                response.put("SystemPower", Float.valueOf(gi.getPowerUsageAvg()));
            }
            gi.triggerPowerUpdate();
        }
        return response;
    }
}

