/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.tileentity;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;
import openccsensors.api.IGaugeSensor;
import openccsensors.api.IMethodCallback;
import openccsensors.common.util.CallbackEventManager;

public class TileEntityGauge
extends TileEntity
implements IPeripheral {
    private static ArrayList gaugeSensors = new ArrayList();
    private HashMap tileProperties = new HashMap();
    private CallbackEventManager eventManager = new CallbackEventManager();
    private int percentage = 0;
    private String updatePropertyName = "";
    private int lastBroadcast = 1;

    public static void addGaugeSensor(IGaugeSensor sensor) {
        gaugeSensors.add(sensor);
    }

    public static ArrayList getGaugeSensors() {
        return gaugeSensors;
    }

    public TileEntityGauge() {
        this.eventManager.registerCallback(new IMethodCallback(){

            @Override
            public String getMethodName() {
                return "getPercentage";
            }

            @Override
            public Object execute(IComputerAccess computer, Object[] arguments) throws Exception {
                return TileEntityGauge.this.getPercentage();
            }
        });
        this.eventManager.registerCallback(new IMethodCallback(){

            @Override
            public String getMethodName() {
                return "setTrackedProperty";
            }

            @Override
            public Object execute(IComputerAccess computer, Object[] arguments) throws Exception {
                TileEntityGauge.this.updatePropertyName = (String)arguments[0];
                return null;
            }
        });
    }

    public Packet func_70319_e() {
        Packet132TileEntityData packet = new Packet132TileEntityData();
        packet.field_73330_d = 0;
        packet.field_73334_a = this.field_70329_l;
        packet.field_73332_b = this.field_70330_m;
        packet.field_73333_c = this.field_70327_n;
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        packet.field_73331_e = nbt;
        return packet;
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        this.func_70307_a(pkt.field_73331_e);
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        this.percentage = nbttagcompound.func_74762_e("percentage");
        this.updatePropertyName = nbttagcompound.func_74779_i("property");
        super.func_70307_a(nbttagcompound);
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("percentage", this.percentage);
        nbttagcompound.func_74778_a("property", this.updatePropertyName);
        super.func_70310_b(nbttagcompound);
    }

    public int getFacing() {
        return this.field_70331_k == null ? 0 : this.func_70322_n();
    }

    public int getPercentage() {
        return this.percentage;
    }

    public String getType() {
        return "gauge";
    }

    public String[] getMethodNames() {
        return this.eventManager.getMethodNames();
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        return new Object[]{this.eventManager.queueMethodCall(computer, method, arguments)};
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        computer.mountFixedDir("ocs", "mods/OCSLua/lua", true, 0L);
    }

    public void detach(IComputerAccess computer) {
    }

    public void func_70316_g() {
        super.func_70316_g();
        this.tileProperties.clear();
        if (this.field_70331_k != null && !this.field_70331_k.field_72995_K) {
            ForgeDirection infront = ForgeDirection.getOrientation((int)this.getFacing());
            ForgeDirection behind = infront.getOpposite();
            TileEntity behindTile = this.field_70331_k.func_72796_p(this.field_70329_l + behind.offsetX, this.field_70330_m, this.field_70327_n + behind.offsetZ);
            if (behindTile != null) {
                for (IGaugeSensor gaugeSensor : gaugeSensors) {
                    if (!gaugeSensor.isValidTarget(behindTile)) continue;
                    HashMap details = gaugeSensor.getDetails(this.field_70331_k, behindTile, Vec3.func_72443_a((double)behindTile.field_70329_l, (double)behindTile.field_70330_m, (double)behindTile.field_70327_n), true);
                    for (String property : gaugeSensor.getGaugeProperties()) {
                        if (!details.containsKey(property)) continue;
                        this.tileProperties.put(property, details.get(property));
                    }
                }
            }
            this.percentage = 0;
            if (this.tileProperties.size() > 0) {
                if (this.updatePropertyName == "" || !this.tileProperties.containsKey(this.updatePropertyName)) {
                    this.updatePropertyName = "";
                    for (String property : new String[]{"HeatPercentage", "Progress", "PowerPercentFull", "InventoryPercentFull"}) {
                        if (this.updatePropertyName != "" || !this.tileProperties.containsKey(property)) continue;
                        this.updatePropertyName = property;
                    }
                    if (this.updatePropertyName == "") {
                        Map.Entry entry = this.tileProperties.entrySet().iterator().next();
                        this.updatePropertyName = (String)entry.getKey();
                    }
                }
                this.percentage = ((Double)this.tileProperties.get(this.updatePropertyName)).intValue();
            }
            if (this.lastBroadcast++ % 10 == 0) {
                this.lastBroadcast = 1;
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
            this.eventManager.process();
        }
    }
}

