/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.sensor;

import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import openccsensors.api.ISensorTier;
import openccsensors.common.util.InventoryUtils;

public abstract class TileSensor {
    public boolean isValidTarget(Object target) {
        return false;
    }

    public HashMap getDetails(TileEntity tile, Vec3 sensorPos) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap<String, Double> position = new HashMap<String, Double>();
        position.put("X", (double)tile.field_70329_l - sensorPos.field_72450_a);
        position.put("Y", (double)tile.field_70330_m - sensorPos.field_72448_b);
        position.put("Z", (double)tile.field_70327_n - sensorPos.field_72449_c);
        response.put("Position", position);
        ItemStack stack = new ItemStack(tile.func_70311_o(), 1, tile.func_70322_n());
        response.put("Name", InventoryUtils.getNameForItemStack(stack));
        response.put("RawName", InventoryUtils.getRawNameForStack(stack));
        response.put("DamageValue", stack.func_77960_j());
        return response;
    }

    public HashMap getTargets(World world, Vec3 location, ISensorTier tier) {
        HashMap<String, TileEntity> targets = new HashMap<String, TileEntity>();
        int distance = (int)tier.getMultiplier();
        for (int x = -distance; x <= distance; ++x) {
            for (int y = -distance; y <= distance; ++y) {
                for (int z = -distance; z <= distance; ++z) {
                    int tileX = x + (int)location.field_72450_a;
                    int tileY = y + (int)location.field_72448_b;
                    int tileZ = z + (int)location.field_72449_c;
                    String name = String.format("%s,%s,%s", x, y, z);
                    TileEntity tile = world.func_72796_p(tileX, tileY, tileZ);
                    if (!this.isValidTarget(tile)) continue;
                    targets.put(name, tile);
                }
            }
        }
        return targets;
    }
}

