/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.sensor;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import openccsensors.api.IRequiresIconLoading;
import openccsensors.api.ISensor;
import openccsensors.api.ISensorTier;

public class SonicSensor
implements ISensor,
IRequiresIconLoading {
    private Icon icon;
    private static final int BASE_RANGE = 3;

    @Override
    public HashMap getDetails(World world, Object obj, Vec3 sensorPos, boolean additional) {
        Vec3 target = (Vec3)obj;
        int x = (int)target.field_72450_a;
        int y = (int)target.field_72448_b;
        int z = (int)target.field_72449_c;
        int id = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[id];
        HashMap<String, Object> response = new HashMap<String, Object>();
        String type = "UNKNOWN";
        if (block != null && block.field_72018_cp != null) {
            if (block.field_72018_cp.func_76224_d()) {
                type = "LIQUID";
            } else if (block.field_72018_cp.func_76220_a()) {
                type = "SOLID";
            }
        }
        response.put("Type", type);
        HashMap<String, Double> position = new HashMap<String, Double>();
        position.put("X", (double)x - sensorPos.field_72450_a);
        position.put("Y", (double)y - sensorPos.field_72448_b);
        position.put("Z", (double)z - sensorPos.field_72449_c);
        response.put("Position", position);
        return response;
    }

    @Override
    public HashMap getTargets(World world, Vec3 location, ISensorTier tier) {
        HashMap<String, Vec3> targets = new HashMap<String, Vec3>();
        int range = new Double(tier.getMultiplier()).intValue() + 3;
        int sx = (int)location.field_72450_a;
        int sy = (int)location.field_72448_b;
        int sz = (int)location.field_72449_c;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    Vec3 targetPos;
                    if (x == 0 && y == 0 && z == 0 || !world.func_72899_e(sx + x, sy + y, sz + z)) continue;
                    int bX = sx + x;
                    int bY = sy + y;
                    int bZ = sz + z;
                    int id = world.func_72798_a(bX, bY, bZ);
                    Block block = Block.field_71973_m[id];
                    if (id == 0 || block == null || !(location.func_72438_d(targetPos = Vec3.func_72443_a((double)bX, (double)bY, (double)bZ)) <= (double)range)) continue;
                    targets.put(String.format("%s,%s,%s", x, y, z), targetPos);
                }
            }
        }
        return targets;
    }

    @Override
    public String[] getCustomMethods(ISensorTier tier) {
        return null;
    }

    @Override
    public Object callCustomMethod(World world, Vec3 location, int methodID, Object[] args, ISensorTier tier) {
        return null;
    }

    @Override
    public String getName() {
        return "sonicCard";
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void loadIcon(IconRegister iconRegistry) {
        this.icon = iconRegistry.func_94245_a("openccsensors:sonic");
    }

    @Override
    public ItemStack getUniqueRecipeItem() {
        return new ItemStack(Block.field_72032_aY);
    }
}

