/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.sensor;

import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import openccsensors.api.IRequiresIconLoading;
import openccsensors.api.ISensor;
import openccsensors.api.ISensorTier;
import openccsensors.common.util.EntityUtils;

public class ProximitySensor
implements ISensor,
IRequiresIconLoading {
    public static final int MODE_ALL = 0;
    public static final int MODE_PLAYERS = 1;
    public static final int MODE_OWNER = 2;
    private Icon icon;

    @Override
    public HashMap getDetails(World world, Object obj, Vec3 sensorPos, boolean additional) {
        return EntityUtils.livingToMap((EntityLiving)obj, sensorPos, additional);
    }

    @Override
    public HashMap getTargets(World world, Vec3 location, ISensorTier tier) {
        double radius = tier.getMultiplier() * 4.0;
        return EntityUtils.getEntities(world, location, radius, EntityLiving.class);
    }

    @Override
    public String[] getCustomMethods(ISensorTier tier) {
        return null;
    }

    @Override
    public Object callCustomMethod(World world, Vec3 location, int methodID, Object[] args, ISensorTier tier) {
        return null;
    }

    @Override
    public String getName() {
        return "proximityCard";
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void loadIcon(IconRegister iconRegistry) {
        this.icon = iconRegistry.func_94245_a("openccsensors:proximity");
    }

    @Override
    public ItemStack getUniqueRecipeItem() {
        return new ItemStack(Block.field_72044_aK);
    }

    public double getDistanceToNearestEntity(World world, Vec3 location, int mode, String owner) {
        Class<EntityLiving> klazz = EntityLiving.class;
        if (mode == 1 || mode == 2) {
            klazz = EntityPlayer.class;
        }
        List list = world.func_72872_a(klazz, AxisAlignedBB.func_72332_a().func_72299_a(location.field_72450_a - 16.0, location.field_72448_b - 16.0, location.field_72449_c - 16.0, location.field_72450_a + 16.0, location.field_72448_b + 16.0, location.field_72449_c + 16.0));
        double closestDistance = Double.MAX_VALUE;
        Vec3 livingPos = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (EntityLiving current : list) {
            if (mode == 2 && !current.func_70023_ak().equals(owner)) continue;
            livingPos.field_72450_a = current.field_70165_t + 0.5;
            livingPos.field_72448_b = current.field_70163_u + 0.5;
            livingPos.field_72449_c = current.field_70161_v + 0.5;
            double distanceTo = location.func_72438_d(livingPos);
            if (!(distanceTo <= 16.0)) continue;
            closestDistance = Math.min(distanceTo, closestDistance);
        }
        return closestDistance;
    }
}

