/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.sensor;

import java.util.HashMap;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import openccsensors.api.IRequiresIconLoading;
import openccsensors.api.ISensor;
import openccsensors.api.ISensorTier;
import openccsensors.common.util.EntityUtils;
import openccsensors.common.util.InventoryUtils;

public class MinecartSensor
implements ISensor,
IRequiresIconLoading {
    private Icon icon;

    @Override
    public HashMap getDetails(World world, Object obj, Vec3 sensorPos, boolean additional) {
        EntityMinecart minecart = (EntityMinecart)obj;
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap<String, Double> position = new HashMap<String, Double>();
        position.put("X", minecart.field_70165_t - sensorPos.field_72450_a);
        position.put("Y", minecart.field_70163_u - sensorPos.field_72448_b);
        position.put("Z", minecart.field_70161_v - sensorPos.field_72449_c);
        response.put("Position", position);
        response.put("Name", minecart.func_70023_ak());
        response.put("RawName", EntityList.func_75621_b((Entity)minecart));
        if (minecart instanceof IInventory) {
            response.put("Slots", InventoryUtils.invToMap((IInventory)minecart));
        }
        if (minecart.field_70153_n != null && minecart.field_70153_n instanceof EntityLiving) {
            response.put("Riding", EntityUtils.livingToMap((EntityLiving)minecart.field_70153_n, sensorPos, true));
        }
        return response;
    }

    @Override
    public HashMap getTargets(World world, Vec3 location, ISensorTier tier) {
        double radius = tier.getMultiplier() * 4.0;
        return EntityUtils.getEntities(world, location, radius, EntityMinecart.class);
    }

    @Override
    public String[] getCustomMethods(ISensorTier tier) {
        return null;
    }

    @Override
    public Object callCustomMethod(World world, Vec3 location, int methodID, Object[] args, ISensorTier tier) {
        return null;
    }

    @Override
    public String getName() {
        return "minecartCard";
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void loadIcon(IconRegister iconRegistry) {
        this.icon = iconRegistry.func_94245_a("openccsensors:minecart");
    }

    @Override
    public ItemStack getUniqueRecipeItem() {
        return new ItemStack(Item.field_77773_az);
    }
}

