/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.sensor;

import java.util.HashMap;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import openccsensors.api.IGaugeSensor;
import openccsensors.api.IRequiresIconLoading;
import openccsensors.api.ISensor;
import openccsensors.api.ISensorTier;
import openccsensors.common.sensor.TileSensor;
import openccsensors.common.util.Ic2Utils;

public class MachineSensor
extends TileSensor
implements ISensor,
IRequiresIconLoading,
IGaugeSensor {
    private Icon icon;
    private String[] gaugeProperties = new String[]{"HeatPercentage", "Progress"};

    @Override
    public String[] getGaugeProperties() {
        return this.gaugeProperties;
    }

    @Override
    public boolean isValidTarget(Object target) {
        return ModLoader.isModLoaded((String)"IC2") && Ic2Utils.isValidMachineTarget(target);
    }

    @Override
    public void loadIcon(IconRegister iconRegistry) {
        this.icon = iconRegistry.func_94245_a("openccsensors:machine");
    }

    @Override
    public HashMap getDetails(World world, Object obj, Vec3 sensorPos, boolean additional) {
        TileEntity tile = (TileEntity)obj;
        HashMap response = super.getDetails(tile, sensorPos);
        if (ModLoader.isModLoaded((String)"IC2")) {
            response.putAll(Ic2Utils.getMachineDetails(world, obj, additional));
        }
        return response;
    }

    @Override
    public String[] getCustomMethods(ISensorTier tier) {
        return null;
    }

    @Override
    public Object callCustomMethod(World world, Vec3 location, int methodID, Object[] args, ISensorTier tier) throws Exception {
        return null;
    }

    @Override
    public String getName() {
        return "machineCard";
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public ItemStack getUniqueRecipeItem() {
        return new ItemStack(Item.field_77767_aC);
    }
}

