/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.sensor;

import java.util.HashMap;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import openccsensors.api.IRequiresIconLoading;
import openccsensors.api.ISensor;
import openccsensors.api.ISensorTier;
import openccsensors.common.util.EntityUtils;
import openccsensors.common.util.InventoryUtils;

public class DroppedItemSensor
implements ISensor,
IRequiresIconLoading {
    private Icon icon;

    @Override
    public HashMap getDetails(World world, Object obj, Vec3 sensorLocation, boolean additional) {
        EntityItem item = (EntityItem)obj;
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap<String, Double> position = new HashMap<String, Double>();
        position.put("X", item.field_70165_t - sensorLocation.field_72450_a);
        position.put("Y", item.field_70163_u - sensorLocation.field_72450_a);
        position.put("Z", item.field_70161_v - sensorLocation.field_72450_a);
        response.put("Position", position);
        ItemStack stack = item.func_92059_d();
        response.put("Name", InventoryUtils.getNameForItemStack(stack));
        response.put("RawName", InventoryUtils.getRawNameForStack(stack));
        if (additional) {
            response.putAll(InventoryUtils.itemstackToMap(stack));
            response.put("IsBurning", item.func_70027_ad());
        }
        return response;
    }

    @Override
    public HashMap getTargets(World world, Vec3 location, ISensorTier tier) {
        double radius = tier.getMultiplier() * 4.0;
        return EntityUtils.getEntities(world, location, radius, EntityItem.class);
    }

    @Override
    public String[] getCustomMethods(ISensorTier tier) {
        return null;
    }

    @Override
    public Object callCustomMethod(World world, Vec3 location, int methodID, Object[] args, ISensorTier tier) {
        return null;
    }

    @Override
    public String getName() {
        return "droppedItemCard";
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void loadIcon(IconRegister iconRegistry) {
        this.icon = iconRegistry.func_94245_a("openccsensors:droppedItem");
    }

    @Override
    public ItemStack getUniqueRecipeItem() {
        return new ItemStack(Item.field_77761_aM);
    }
}

