/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.sensor;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockNetherStalk;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockStem;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import openccsensors.api.IRequiresIconLoading;
import openccsensors.api.ISensor;
import openccsensors.api.ISensorTier;
import openccsensors.common.util.Ic2Utils;

public class CropSensor
implements ISensor,
IRequiresIconLoading {
    public static final String STATUS_NEW = "New";
    public static final String STATUS_GROWING = "Growing";
    public static final String STATUS_GROWN = "Grown";
    private Icon icon;

    @Override
    public void loadIcon(IconRegister iconRegistry) {
        this.icon = iconRegistry.func_94245_a("openccsensors:crop");
    }

    @Override
    public HashMap getDetails(World world, Object obj, Vec3 sensorPos, boolean additional) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (obj instanceof CropTarget) {
            CropTarget target = (CropTarget)obj;
            HashMap<String, Double> position = new HashMap<String, Double>();
            position.put("X", (double)target.X - sensorPos.field_72450_a);
            position.put("Y", (double)target.Y - sensorPos.field_72448_b);
            position.put("Z", (double)target.Z - sensorPos.field_72449_c);
            response.put("Position", position);
            response.put("Name", target.block.func_71931_t());
            response.put("RawName", target.block.func_71917_a());
            response.put("Size", target.metadata);
            if (target.block instanceof BlockCrops || target.block instanceof BlockStem) {
                if (target.metadata == 0) {
                    response.put("Status", STATUS_NEW);
                } else if (target.metadata == 7) {
                    response.put("Status", STATUS_GROWN);
                } else {
                    response.put("Status", STATUS_GROWING);
                }
            } else if (target.block instanceof BlockNetherStalk) {
                if (target.metadata == 0) {
                    response.put("Status", STATUS_NEW);
                } else {
                    response.put("Status", STATUS_GROWN);
                }
            } else if (target.block instanceof BlockPumpkin || target.block instanceof BlockMelon) {
                response.put("Status", STATUS_GROWN);
            }
        } else if (ModLoader.isModLoaded((String)"IC2") && obj instanceof TileEntity) {
            response.putAll(Ic2Utils.getCropDetails(obj, sensorPos, additional));
        }
        return response;
    }

    @Override
    public String[] getCustomMethods(ISensorTier tier) {
        return null;
    }

    @Override
    public Object callCustomMethod(World world, Vec3 location, int methodID, Object[] args, ISensorTier tier) throws Exception {
        return null;
    }

    @Override
    public String getName() {
        return "cropCard";
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public ItemStack getUniqueRecipeItem() {
        return new ItemStack(Item.field_77685_T);
    }

    @Override
    public HashMap getTargets(World world, Vec3 location, ISensorTier tier) {
        HashMap<String, CropTarget> targets = new HashMap<String, CropTarget>();
        int distance = (int)tier.getMultiplier();
        for (int x = -distance; x <= distance; ++x) {
            for (int y = -distance; y <= distance; ++y) {
                for (int z = -distance; z <= distance; ++z) {
                    int tileX = x + (int)location.field_72450_a;
                    int tileY = y + (int)location.field_72448_b;
                    int tileZ = z + (int)location.field_72449_c;
                    String name = String.format("%s,%s,%s", x, y, z);
                    Block b = Block.field_71973_m[world.func_72798_a(tileX, tileY, tileZ)];
                    if (b != null && (b instanceof BlockCrops || b instanceof BlockNetherStalk || b instanceof BlockStem || b instanceof BlockPumpkin || b instanceof BlockMelon)) {
                        CropTarget potentialTarget = new CropTarget(tileX, tileY, tileZ, b, world.func_72805_g(tileX, tileY, tileZ));
                        targets.put(name, potentialTarget);
                        continue;
                    }
                    TileEntity tile = world.func_72796_p(tileX, tileY, tileZ);
                    if (!(tile != null & ModLoader.isModLoaded((String)"IC2")) || !Ic2Utils.isValidCropTarget(tile)) continue;
                    targets.put(name, (CropTarget)tile);
                }
            }
        }
        return targets;
    }

    class CropTarget {
        public int X;
        public int Y;
        public int Z;
        public Block block;
        public int metadata;

        public CropTarget(int x, int y, int z, Block b, int metadata) {
            this.X = x;
            this.Y = y;
            this.Z = z;
            this.block = b;
            this.metadata = metadata;
        }
    }
}

