/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import openccsensors.OpenCCSensors;
import openccsensors.api.EnumItemRarity;
import openccsensors.api.IRequiresIconLoading;
import openccsensors.api.ISensor;
import openccsensors.api.ISensorCardRegistry;
import openccsensors.api.ISensorTier;
import openccsensors.api.SensorCard;
import openccsensors.common.SensorTier;
import openccsensors.common.util.RecipeUtils;

public class ItemSensorCard
extends Item
implements ISensorCardRegistry {
    public List iconLoadList = new ArrayList();
    public HashMap cards = new HashMap();

    public ItemSensorCard() {
        super(OpenCCSensors.Config.sensorCardID);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(OpenCCSensors.tabOpenCCSensors);
    }

    public String func_77667_c(ItemStack itemStack) {
        SensorCard card = this.getSensorCard(itemStack);
        if (card == null) {
            return "";
        }
        return String.format("item.openccsensors.%s", card.getSensor().getName());
    }

    public void registerSensors() {
        SensorTier tier1 = new SensorTier("Mk. I", EnumItemRarity.COMMON, 2, "openccsensors:tier1");
        SensorTier tier2 = new SensorTier("Mk. II", EnumItemRarity.UNCOMMON, 4, "openccsensors:tier2");
        SensorTier tier3 = new SensorTier("Mk. III", EnumItemRarity.RARE, 6, "openccsensors:tier3");
        SensorTier tier4 = new SensorTier("Mk. IV", EnumItemRarity.EPIC, 8, "openccsensors:tier4");
        this.addIconsForLoading(tier1, tier2, tier3, tier4);
        OpenCCSensors.Tiers.tier1 = tier1;
        OpenCCSensors.Tiers.tier2 = tier2;
        OpenCCSensors.Tiers.tier3 = tier3;
        OpenCCSensors.Tiers.tier4 = tier4;
        this.addSensorCard(1, new SensorCard(OpenCCSensors.Sensors.proximitySensor, tier1));
        this.addSensorCard(2, new SensorCard(OpenCCSensors.Sensors.proximitySensor, tier2));
        this.addSensorCard(3, new SensorCard(OpenCCSensors.Sensors.proximitySensor, tier3));
        this.addSensorCard(4, new SensorCard(OpenCCSensors.Sensors.proximitySensor, tier4));
        this.addIconsForLoading(OpenCCSensors.Sensors.proximitySensor);
        this.addSensorCard(5, new SensorCard(OpenCCSensors.Sensors.droppedItemSensor, tier1));
        this.addSensorCard(6, new SensorCard(OpenCCSensors.Sensors.droppedItemSensor, tier2));
        this.addSensorCard(7, new SensorCard(OpenCCSensors.Sensors.droppedItemSensor, tier3));
        this.addSensorCard(8, new SensorCard(OpenCCSensors.Sensors.droppedItemSensor, tier4));
        this.addIconsForLoading(OpenCCSensors.Sensors.droppedItemSensor);
        this.addSensorCard(9, new SensorCard(OpenCCSensors.Sensors.signSensor, tier1));
        this.addSensorCard(10, new SensorCard(OpenCCSensors.Sensors.signSensor, tier2));
        this.addSensorCard(11, new SensorCard(OpenCCSensors.Sensors.signSensor, tier3));
        this.addSensorCard(12, new SensorCard(OpenCCSensors.Sensors.signSensor, tier4));
        this.addIconsForLoading(OpenCCSensors.Sensors.signSensor);
        this.addSensorCard(13, new SensorCard(OpenCCSensors.Sensors.minecartSensor, tier1));
        this.addSensorCard(14, new SensorCard(OpenCCSensors.Sensors.minecartSensor, tier2));
        this.addSensorCard(15, new SensorCard(OpenCCSensors.Sensors.minecartSensor, tier3));
        this.addSensorCard(16, new SensorCard(OpenCCSensors.Sensors.minecartSensor, tier4));
        this.addIconsForLoading(OpenCCSensors.Sensors.minecartSensor);
        this.addSensorCard(17, new SensorCard(OpenCCSensors.Sensors.sonicSensor, tier1));
        this.addSensorCard(18, new SensorCard(OpenCCSensors.Sensors.sonicSensor, tier2));
        this.addSensorCard(19, new SensorCard(OpenCCSensors.Sensors.sonicSensor, tier3));
        this.addSensorCard(20, new SensorCard(OpenCCSensors.Sensors.sonicSensor, tier4));
        this.addIconsForLoading(OpenCCSensors.Sensors.sonicSensor);
        this.addSensorCard(21, new SensorCard(OpenCCSensors.Sensors.tankSensor, tier1));
        this.addSensorCard(22, new SensorCard(OpenCCSensors.Sensors.tankSensor, tier2));
        this.addSensorCard(23, new SensorCard(OpenCCSensors.Sensors.tankSensor, tier3));
        this.addSensorCard(24, new SensorCard(OpenCCSensors.Sensors.tankSensor, tier4));
        this.addIconsForLoading(OpenCCSensors.Sensors.tankSensor);
        this.addSensorCard(25, new SensorCard(OpenCCSensors.Sensors.inventorySensor, tier1));
        this.addSensorCard(26, new SensorCard(OpenCCSensors.Sensors.inventorySensor, tier2));
        this.addSensorCard(27, new SensorCard(OpenCCSensors.Sensors.inventorySensor, tier3));
        this.addSensorCard(28, new SensorCard(OpenCCSensors.Sensors.inventorySensor, tier4));
        this.addIconsForLoading(OpenCCSensors.Sensors.inventorySensor);
        this.addSensorCard(29, new SensorCard(OpenCCSensors.Sensors.worldSensor, tier1));
        this.addIconsForLoading(OpenCCSensors.Sensors.worldSensor);
        this.addSensorCard(30, new SensorCard(OpenCCSensors.Sensors.powerSensor, tier1));
        this.addSensorCard(31, new SensorCard(OpenCCSensors.Sensors.powerSensor, tier2));
        this.addSensorCard(32, new SensorCard(OpenCCSensors.Sensors.powerSensor, tier3));
        this.addSensorCard(33, new SensorCard(OpenCCSensors.Sensors.powerSensor, tier4));
        this.addIconsForLoading(OpenCCSensors.Sensors.powerSensor);
        this.addSensorCard(34, new SensorCard(OpenCCSensors.Sensors.machineSensor, tier1));
        this.addSensorCard(35, new SensorCard(OpenCCSensors.Sensors.machineSensor, tier2));
        this.addSensorCard(36, new SensorCard(OpenCCSensors.Sensors.machineSensor, tier3));
        this.addSensorCard(37, new SensorCard(OpenCCSensors.Sensors.machineSensor, tier4));
        this.addIconsForLoading(OpenCCSensors.Sensors.machineSensor);
        this.addSensorCard(38, new SensorCard(OpenCCSensors.Sensors.cropSensor, tier1));
        this.addSensorCard(39, new SensorCard(OpenCCSensors.Sensors.cropSensor, tier2));
        this.addSensorCard(40, new SensorCard(OpenCCSensors.Sensors.cropSensor, tier3));
        this.addSensorCard(41, new SensorCard(OpenCCSensors.Sensors.cropSensor, tier4));
        this.addIconsForLoading(OpenCCSensors.Sensors.cropSensor);
    }

    public void addIconsForLoading(IRequiresIconLoading ... list) {
        this.iconLoadList.addAll(Arrays.asList(list));
    }

    public void func_94581_a(IconRegister iconRegister) {
        for (IRequiresIconLoading item : this.iconLoadList) {
            item.loadIcon(iconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        SensorCard card = this.getSensorCard(itemStack);
        if (card != null) {
            ISensorTier tier = card.getTier();
            list.add(tier.getName());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemStack) {
        SensorCard card = this.getSensorCard(itemStack);
        if (card != null) {
            ISensorTier tier = card.getTier();
            switch (tier.getRarity()) {
                case COMMON: {
                    return EnumRarity.common;
                }
                case UNCOMMON: {
                    return EnumRarity.uncommon;
                }
                case RARE: {
                    return EnumRarity.rare;
                }
                case EPIC: {
                    return EnumRarity.epic;
                }
            }
        }
        return EnumRarity.common;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int id, CreativeTabs tab, List subItems) {
        for (Map.Entry entry : this.cards.entrySet()) {
            subItems.add(new ItemStack(id, 1, ((Integer)entry.getKey()).intValue()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77618_c(int dmgValue, int renderPass) {
        SensorCard card = this.getSensorCard(dmgValue);
        if (card == null) {
            card = this.getSensorCard(0);
        }
        return card.getIconForRenderPass(renderPass);
    }

    public SensorCard getSensorCard(ItemStack stack) {
        return this.getSensorCard(stack.func_77960_j());
    }

    public SensorCard getSensorCard(int id) {
        return (SensorCard)this.cards.get(id);
    }

    public Map.Entry getEntryForSensorAndTier(ISensor sensor, SensorTier tier) {
        for (Map.Entry entry : this.cards.entrySet()) {
            if (((SensorCard)entry.getValue()).getSensor() != sensor || ((SensorCard)entry.getValue()).getTier() != tier) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void addSensorCard(int id, SensorCard sensorCard) {
        this.cards.put(id, sensorCard);
        if (sensorCard.getTier() == OpenCCSensors.Tiers.tier1) {
            RecipeUtils.addTier1Recipe(sensorCard.getSensor().getUniqueRecipeItem(), new ItemStack((Item)OpenCCSensors.Items.sensorCard, 1, id));
        } else if (sensorCard.getTier() == OpenCCSensors.Tiers.tier2) {
            Map.Entry previousTier = this.getEntryForSensorAndTier(sensorCard.getSensor(), OpenCCSensors.Tiers.tier1);
            RecipeUtils.addTier2Recipe(new ItemStack((Item)OpenCCSensors.Items.sensorCard, 1, ((Integer)previousTier.getKey()).intValue()), new ItemStack((Item)OpenCCSensors.Items.sensorCard, 1, id));
        } else if (sensorCard.getTier() == OpenCCSensors.Tiers.tier3) {
            Map.Entry previousTier = this.getEntryForSensorAndTier(sensorCard.getSensor(), OpenCCSensors.Tiers.tier2);
            RecipeUtils.addTier3Recipe(new ItemStack((Item)OpenCCSensors.Items.sensorCard, 1, ((Integer)previousTier.getKey()).intValue()), new ItemStack((Item)OpenCCSensors.Items.sensorCard, 1, id));
        } else if (sensorCard.getTier() == OpenCCSensors.Tiers.tier4) {
            Map.Entry previousTier = this.getEntryForSensorAndTier(sensorCard.getSensor(), OpenCCSensors.Tiers.tier3);
            RecipeUtils.addTier4Recipe(new ItemStack((Item)OpenCCSensors.Items.sensorCard, 1, ((Integer)previousTier.getKey()).intValue()), new ItemStack((Item)OpenCCSensors.Items.sensorCard, 1, id));
        }
    }
}

