/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openccsensors.OpenCCSensors;
import openccsensors.api.IBasicSensor;
import openccsensors.common.tileentity.basic.TileEntityBasicProximitySensor;

public class BlockBasicSensor
extends BlockContainer {
    public static final int PROXIMITY_SENSOR_ID = 0;

    public BlockBasicSensor() {
        super(OpenCCSensors.Config.basicSensorBlockID, Material.field_76248_c);
        this.func_71848_c(0.5f);
        this.func_71849_a(OpenCCSensors.tabOpenCCSensors);
        GameRegistry.registerBlock((Block)this, (String)"basicProximitySensor");
        GameRegistry.registerTileEntity(TileEntityBasicProximitySensor.class, (String)"basicProximitySensor");
        this.func_71864_b("openccsensors.proximitysensor");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int unknown, CreativeTabs tab, List subItems) {
        subItems.add(new ItemStack((Block)this, 1, 0));
    }

    public void func_94332_a(IconRegister iconRegister) {
        Icons.top = iconRegister.func_94245_a("openccsensors:proxTop");
        Icons.bottom = iconRegister.func_94245_a("openccsensors:proxBottom");
        Icons.sideAll = iconRegister.func_94245_a("openccsensors:proxSideAll");
        Icons.sidePlayers = iconRegister.func_94245_a("openccsensors:proxSidePlayers");
        Icons.sideOwner = iconRegister.func_94245_a("openccsensors:proxSideOwner");
    }

    public Icon func_71858_a(int side, int par2) {
        switch (side) {
            case 0: {
                return Icons.bottom;
            }
            case 1: {
                return Icons.top;
            }
        }
        return Icons.sideAll;
    }

    public Icon func_71895_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        switch (side) {
            case 0: {
                return Icons.bottom;
            }
            case 1: {
                return Icons.top;
            }
        }
        TileEntity tile = blockAccess.func_72796_p(x, y, z);
        if (tile != null && tile instanceof TileEntityBasicProximitySensor) {
            switch (((TileEntityBasicProximitySensor)tile).getEntityMode()) {
                case 0: {
                    return Icons.sideAll;
                }
                case 2: {
                    return Icons.sideOwner;
                }
                case 1: {
                    return Icons.sidePlayers;
                }
            }
        }
        return Icons.sideAll;
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityBasicProximitySensor();
    }

    public boolean func_71853_i() {
        return true;
    }

    public int func_71865_a(IBlockAccess iblockaccess, int x, int y, int z, int m) {
        TileEntity tile = iblockaccess.func_72796_p(x, y, z);
        if (tile != null && tile instanceof IBasicSensor) {
            return ((IBasicSensor)tile).getPowerOutput();
        }
        return 0;
    }

    public int func_71855_c(IBlockAccess iblockaccess, int x, int y, int z, int m) {
        return this.func_71865_a(iblockaccess, x, y, z, m);
    }

    public void func_71852_a(World worldObj, int xCoord, int yCoord, int zCoord, int par5, int par6) {
        int blockId = OpenCCSensors.Config.basicSensorBlockID;
        worldObj.func_72898_h(xCoord, yCoord - 1, zCoord, blockId);
        worldObj.func_72898_h(xCoord, yCoord + 1, zCoord, blockId);
        worldObj.func_72898_h(xCoord - 1, yCoord, zCoord, blockId);
        worldObj.func_72898_h(xCoord + 1, yCoord, zCoord, blockId);
        worldObj.func_72898_h(xCoord, yCoord, zCoord - 1, blockId);
        worldObj.func_72898_h(xCoord, yCoord, zCoord + 1, blockId);
        super.func_71852_a(worldObj, xCoord, yCoord, zCoord, par5, par6);
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving player, ItemStack itemStack) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile != null && tile instanceof TileEntityBasicProximitySensor) {
            ((TileEntityBasicProximitySensor)tile).setOwner(player.func_70023_ak());
        }
        super.func_71860_a(world, x, y, z, player, itemStack);
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                return false;
            }
            TileEntity tile = world.func_72796_p(x, y, z);
            if (tile != null && tile instanceof TileEntityBasicProximitySensor) {
                ((TileEntityBasicProximitySensor)tile).onBlockClicked(player);
            }
        }
        return true;
    }

    public boolean canBeReplacedByLeaves(World world, int x, int y, int z) {
        return false;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return false;
    }

    public static class Icons {
        public static Icon top;
        public static Icon bottom;
        public static Icon sideAll;
        public static Icon sideOwner;
        public static Icon sidePlayers;
    }
}

