/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks.logic;

import mods.tinker.tconstruct.blocks.logic.MultiServantLogic;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class LavaTankLogic
extends MultiServantLogic
implements ITankContainer {
    public LiquidTank tank = new LiquidTank(4000);
    public int renderOffset;

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        int amount = this.tank.fill(resource, doFill);
        if (amount > 0 && doFill) {
            this.renderOffset = resource.amount;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return amount;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        LiquidStack amount = this.tank.drain(maxDrain, doDrain);
        if (amount != null && doDrain) {
            this.renderOffset = -maxDrain;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return amount;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.tank;
    }

    public float getLiquidAmountScaled() {
        return (float)(this.tank.getLiquid().amount - this.renderOffset) / ((float)this.tank.getCapacity() * 1.01f);
    }

    public boolean containsLiquid() {
        return this.tank.getLiquid() != null;
    }

    public int getBrightness() {
        int id;
        if (this.containsLiquid() && (id = this.tank.getLiquid().itemID) < 4096) {
            return Block.field_71984_q[id];
        }
        return 0;
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.readCustomNBT(tags);
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        this.writeCustomNBT(tags);
    }

    @Override
    public void readCustomNBT(NBTTagCompound tags) {
        if (tags.func_74767_n("hasLiquid")) {
            this.tank.setLiquid(new LiquidStack(tags.func_74762_e("itemID"), tags.func_74762_e("amount"), tags.func_74762_e("itemMeta")));
        } else {
            this.tank.setLiquid(null);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tags) {
        LiquidStack liquid = this.tank.getLiquid();
        tags.func_74757_a("hasLiquid", liquid != null);
        if (liquid != null) {
            tags.func_74768_a("itemID", liquid.itemID);
            tags.func_74768_a("amount", liquid.amount);
            tags.func_74768_a("itemMeta", liquid.itemMeta);
        }
    }

    @Override
    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.readCustomNBT(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_70316_g() {
        if (this.renderOffset > 0) {
            this.renderOffset -= 6;
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }
}

