/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks.logic;

import mods.tinker.tconstruct.library.util.IActiveLogic;
import mods.tinker.tconstruct.library.util.IFacingLogic;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class FaucetLogic
extends TileEntity
implements IFacingLogic,
IActiveLogic,
ITankContainer {
    byte direction;
    boolean active;
    public LiquidStack liquid;

    public boolean activateFaucet() {
        if (this.liquid == null && this.active) {
            LiquidStack templiquid;
            int x = this.field_70329_l;
            int z = this.field_70327_n;
            switch (this.getRenderDirection()) {
                case 2: {
                    ++z;
                    break;
                }
                case 3: {
                    --z;
                    break;
                }
                case 4: {
                    ++x;
                    break;
                }
                case 5: {
                    --x;
                }
            }
            TileEntity drainte = this.field_70331_k.func_72796_p(x, this.field_70330_m, z);
            TileEntity tankte = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
            if (drainte != null && drainte instanceof ITankContainer && tankte != null && tankte instanceof ITankContainer && (templiquid = ((ITankContainer)drainte).drain(this.getForgeDirection(), 144, false)) != null) {
                int drained = ((ITankContainer)tankte).fill(ForgeDirection.UP, templiquid, false);
                if (drained > 0) {
                    this.liquid = ((ITankContainer)drainte).drain(this.getForgeDirection(), drained, true);
                    ((ITankContainer)tankte).fill(ForgeDirection.UP, this.liquid, true);
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void func_70316_g() {
        if (this.liquid != null) {
            this.liquid.amount -= 6;
            if (this.liquid.amount <= 0) {
                this.liquid = null;
                if (!this.activateFaucet()) {
                    this.active = false;
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
            }
        }
    }

    @Override
    public byte getRenderDirection() {
        return this.direction;
    }

    @Override
    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    @Override
    public void setDirection(int side) {
    }

    @Override
    public void setDirection(float yaw, float pitch, EntityLiving player) {
        int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
        switch (facing) {
            case 0: {
                this.direction = (byte)2;
                break;
            }
            case 1: {
                this.direction = (byte)5;
                break;
            }
            case 2: {
                this.direction = (byte)3;
                break;
            }
            case 3: {
                this.direction = (byte)4;
            }
        }
    }

    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.readCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.direction = tags.func_74771_c("Direction");
        this.liquid = tags.func_74767_n("hasLiquid") ? new LiquidStack(tags.func_74762_e("itemID"), tags.func_74762_e("amount"), tags.func_74762_e("itemMeta")) : null;
    }

    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        this.writeCustomNBT(tags);
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74774_a("Direction", this.direction);
        tags.func_74757_a("hasLiquid", this.liquid != null);
        if (this.liquid != null) {
            tags.func_74768_a("itemID", this.liquid.itemID);
            tags.func_74768_a("amount", this.liquid.amount);
            tags.func_74768_a("itemMeta", this.liquid.itemMeta);
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.readCustomNBT(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean flag) {
        if (!this.active) {
            this.active = true;
            this.activateFaucet();
        } else {
            this.active = false;
        }
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return null;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return null;
    }
}

