/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks.fluid;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.tinker.tconstruct.blocks.logic.LiquidTextureLogic;
import mods.tinker.tconstruct.client.block.FluidRender;
import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.library.TConstructRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class LiquidMetalBase
extends Block {
    public static String[] textureNames = new String[]{"iron", "gold", "copper", "tin", "aluminum", "cobalt", "ardite", "bronze", "alubrass", "manyullyn", "alumite", "obsidian", "steel", "glass", "stone", "villager", "cow", "ferrous", "lead", "silver", "shiny", "invar", "electrum", "ender"};
    public Icon[] stillInoms;
    public Icon[] flowInoms;

    protected LiquidMetalBase(int par1, Material par2Material) {
        super(par1, par2Material);
        this.func_71900_a(0.625f);
        this.func_71849_a(TConstructRegistry.blockTab);
    }

    public void func_94332_a(IconRegister iconRegister) {
        this.stillInoms = new Icon[textureNames.length];
        this.flowInoms = new Icon[textureNames.length];
        for (int i = 0; i < this.stillInoms.length; ++i) {
            this.stillInoms[i] = iconRegister.func_94245_a("tinker:liquid_" + textureNames[i]);
            this.flowInoms[i] = iconRegister.func_94245_a("tinker:liquid_" + textureNames[i] + "_flow");
        }
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity logic = world.func_72796_p(x, y, z);
        if (logic != null && logic instanceof LiquidTextureLogic) {
            if (side == 1 || side == 0) {
                return this.stillInoms[((LiquidTextureLogic)logic).getLiquidType()];
            }
            return this.flowInoms[((LiquidTextureLogic)logic).getLiquidType()];
        }
        int meta = world.func_72805_g(x, y, z);
        return this.func_71858_a(side, meta);
    }

    public Icon func_71858_a(int side, int meta) {
        int pos = MathHelper.func_76125_a((int)meta, (int)0, (int)(this.stillInoms.length - 1));
        if (side == 0 || side == 1) {
            return this.stillInoms[pos];
        }
        return this.flowInoms[pos];
    }

    public int func_71857_b() {
        return FluidRender.fluidModel;
    }

    @SideOnly(value=Side.CLIENT)
    public static double getFlowDirection(IBlockAccess par0IBlockAccess, int par1, int par2, int par3, Material par4Material) {
        Vec3 var5 = ((LiquidMetalBase)TContent.liquidMetalFlowing).getFlowVector(par0IBlockAccess, par1, par2, par3);
        return var5.field_72450_a == 0.0 && var5.field_72449_c == 0.0 ? -1000.0 : Math.atan2(var5.field_72449_c, var5.field_72450_a) - 1.5707963267948966;
    }

    private Vec3 getFlowVector(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        Vec3 var5 = par1IBlockAccess.func_82732_R().func_72345_a(0.0, 0.0, 0.0);
        int var6 = this.getEffectiveFlowDecay(par1IBlockAccess, par2, par3, par4);
        for (int var7 = 0; var7 < 4; ++var7) {
            int var12;
            int var11;
            int var8 = par2;
            int var10 = par4;
            if (var7 == 0) {
                var8 = par2 - 1;
            }
            if (var7 == 1) {
                var10 = par4 - 1;
            }
            if (var7 == 2) {
                ++var8;
            }
            if (var7 == 3) {
                ++var10;
            }
            if ((var11 = this.getEffectiveFlowDecay(par1IBlockAccess, var8, par3, var10)) < 0) {
                if (par1IBlockAccess.func_72803_f(var8, par3, var10).func_76230_c() || (var11 = this.getEffectiveFlowDecay(par1IBlockAccess, var8, par3 - 1, var10)) < 0) continue;
                var12 = var11 - (var6 - 8);
                var5 = var5.func_72441_c((double)((var8 - par2) * var12), (double)((par3 - par3) * var12), (double)((var10 - par4) * var12));
                continue;
            }
            if (var11 < 0) continue;
            var12 = var11 - var6;
            var5 = var5.func_72441_c((double)((var8 - par2) * var12), (double)((par3 - par3) * var12), (double)((var10 - par4) * var12));
        }
        if (par1IBlockAccess.func_72805_g(par2, par3, par4) >= 8) {
            boolean var13 = false;
            if (var13 || this.func_71924_d(par1IBlockAccess, par2, par3, par4 - 1, 2)) {
                var13 = true;
            }
            if (var13 || this.func_71924_d(par1IBlockAccess, par2, par3, par4 + 1, 3)) {
                var13 = true;
            }
            if (var13 || this.func_71924_d(par1IBlockAccess, par2 - 1, par3, par4, 4)) {
                var13 = true;
            }
            if (var13 || this.func_71924_d(par1IBlockAccess, par2 + 1, par3, par4, 5)) {
                var13 = true;
            }
            if (var13 || this.func_71924_d(par1IBlockAccess, par2, par3 + 1, par4 - 1, 2)) {
                var13 = true;
            }
            if (var13 || this.func_71924_d(par1IBlockAccess, par2, par3 + 1, par4 + 1, 3)) {
                var13 = true;
            }
            if (var13 || this.func_71924_d(par1IBlockAccess, par2 - 1, par3 + 1, par4, 4)) {
                var13 = true;
            }
            if (var13 || this.func_71924_d(par1IBlockAccess, par2 + 1, par3 + 1, par4, 5)) {
                var13 = true;
            }
            if (var13) {
                var5 = var5.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
            }
        }
        var5 = var5.func_72432_b();
        return var5;
    }

    public boolean func_71918_c(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return this.field_72018_cp != Material.field_76256_h;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71933_m() {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71920_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        if (this.field_72018_cp != Material.field_76244_g) {
            return 0xFFFFFF;
        }
        int var5 = 0;
        int var6 = 0;
        int var7 = 0;
        for (int var8 = -1; var8 <= 1; ++var8) {
            for (int var9 = -1; var9 <= 1; ++var9) {
                int var10 = par1IBlockAccess.func_72807_a(par2 + var9, par4 + var8).getWaterColorMultiplier();
                var5 += (var10 & 0xFF0000) >> 16;
                var6 += (var10 & 0xFF00) >> 8;
                var7 += var10 & 0xFF;
            }
        }
        return (var5 / 9 & 0xFF) << 16 | (var6 / 9 & 0xFF) << 8 | var7 / 9 & 0xFF;
    }

    public static float getFluidHeightPercent(int par0) {
        if (par0 >= 8) {
            par0 = 0;
        }
        return (float)(par0 + 1) / 9.0f;
    }

    protected int getFlowDecay(World par1World, int par2, int par3, int par4) {
        return par1World.func_72803_f(par2, par3, par4) == this.field_72018_cp ? par1World.func_72805_g(par2, par3, par4) : -1;
    }

    protected int getEffectiveFlowDecay(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        if (par1IBlockAccess.func_72803_f(par2, par3, par4) != this.field_72018_cp) {
            return -1;
        }
        int var5 = par1IBlockAccess.func_72805_g(par2, par3, par4);
        if (var5 >= 8) {
            var5 = 0;
        }
        return var5;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71913_a(int par1, boolean par2) {
        return par2 && par1 == 0;
    }

    public boolean func_71924_d(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        Material var6 = par1IBlockAccess.func_72803_f(par2, par3, par4);
        return var6 == this.field_72018_cp ? false : (par5 == 1 ? true : (var6 == Material.field_76260_u ? false : super.func_71924_d(par1IBlockAccess, par2, par3, par4, par5)));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_71877_c(IBlockAccess world, int x, int y, int z, int side) {
        Material material = world.func_72803_f(x, y, z);
        int blockID = world.func_72798_a(x, y, z);
        if (blockID != TContent.liquidMetalFlowing.field_71990_ca && blockID != TContent.liquidMetalStill.field_71990_ca) {
            return true;
        }
        return material == this.field_72018_cp ? false : (side == 1 ? true : (material == Material.field_76260_u ? false : super.func_71877_c(world, x, y, z, side)));
    }

    public AxisAlignedBB func_71872_e(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public void func_71869_a(World par1World, int x, int y, int z, Entity entity) {
        entity.field_70159_w *= 0.4;
        entity.field_70179_y *= 0.4;
        if (!(entity instanceof EntityItem) && !entity.func_70045_F()) {
            entity.func_70097_a(DamageSource.field_76371_c, 4);
            entity.func_70015_d(15);
        }
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return 0;
    }

    public int func_71925_a(Random par1Random) {
        return 0;
    }

    public void func_71901_a(World par1World, int par2, int par3, int par4, Entity par5Entity, Vec3 par6Vec3) {
        Vec3 var7 = this.getFlowVector((IBlockAccess)par1World, par2, par3, par4);
        par6Vec3.field_72450_a += var7.field_72450_a;
        par6Vec3.field_72448_b += var7.field_72448_b;
        par6Vec3.field_72449_c += var7.field_72449_c;
    }

    public int tickRate() {
        return 30;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71874_e(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int var5 = par1IBlockAccess.func_72802_i(par2, par3, par4, 0);
        int var6 = par1IBlockAccess.func_72802_i(par2, par3 + 1, par4, 0);
        int var7 = var5 & 0xFF;
        int var8 = var6 & 0xFF;
        int var9 = var5 >> 16 & 0xFF;
        int var10 = var6 >> 16 & 0xFF;
        return (var7 > var8 ? var7 : var8) | (var9 > var10 ? var9 : var10) << 16;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_71870_f(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71856_s_() {
        return this.field_72018_cp == Material.field_76244_g ? 1 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        double var22;
        int var6;
        if (this.field_72018_cp == Material.field_76244_g) {
            if (par5Random.nextInt(10) == 0 && ((var6 = par1World.func_72805_g(par2, par3, par4)) <= 0 || var6 >= 8)) {
                par1World.func_72869_a("suspended", (double)((float)par2 + par5Random.nextFloat()), (double)((float)par3 + par5Random.nextFloat()), (double)((float)par4 + par5Random.nextFloat()), 0.0, 0.0, 0.0);
            }
            for (var6 = 0; var6 < 0; ++var6) {
                int var7 = par5Random.nextInt(4);
                int var8 = par2;
                int var9 = par4;
                if (var7 == 0) {
                    var8 = par2 - 1;
                }
                if (var7 == 1) {
                    ++var8;
                }
                if (var7 == 2) {
                    var9 = par4 - 1;
                }
                if (var7 == 3) {
                    ++var9;
                }
                if (par1World.func_72803_f(var8, par3, var9) != Material.field_76249_a || !par1World.func_72803_f(var8, par3 - 1, var9).func_76230_c() && !par1World.func_72803_f(var8, par3 - 1, var9).func_76224_d()) continue;
                float var10 = 0.0625f;
                double var11 = (float)par2 + par5Random.nextFloat();
                double var13 = (float)par3 + par5Random.nextFloat();
                double var15 = (float)par4 + par5Random.nextFloat();
                if (var7 == 0) {
                    var11 = (float)par2 - var10;
                }
                if (var7 == 1) {
                    var11 = (float)(par2 + 1) + var10;
                }
                if (var7 == 2) {
                    var15 = (float)par4 - var10;
                }
                if (var7 == 3) {
                    var15 = (float)(par4 + 1) + var10;
                }
                double var17 = 0.0;
                double var19 = 0.0;
                if (var7 == 0) {
                    var17 = -var10;
                }
                if (var7 == 1) {
                    var17 = var10;
                }
                if (var7 == 2) {
                    var19 = -var10;
                }
                if (var7 == 3) {
                    var19 = var10;
                }
                par1World.func_72869_a("splash", var11, var13, var15, var17, 0.0, var19);
            }
        }
        if (this.field_72018_cp == Material.field_76244_g && par5Random.nextInt(64) == 0 && (var6 = par1World.func_72805_g(par2, par3, par4)) > 0 && var6 < 8) {
            par1World.func_72980_b((double)((float)par2 + 0.5f), (double)((float)par3 + 0.5f), (double)((float)par4 + 0.5f), "liquid.water", par5Random.nextFloat() * 0.25f + 0.75f, par5Random.nextFloat() * 1.0f + 0.5f, false);
        }
        if (this.field_72018_cp == Material.field_76256_h && par1World.func_72803_f(par2, par3 + 1, par4) == Material.field_76249_a && !par1World.func_72804_r(par2, par3 + 1, par4)) {
            if (par5Random.nextInt(100) == 0) {
                double var21 = (float)par2 + par5Random.nextFloat();
                var22 = (double)par3 + this.field_72022_cl;
                double var23 = (float)par4 + par5Random.nextFloat();
                par1World.func_72869_a("lava", var21, var22, var23, 0.0, 0.0, 0.0);
                par1World.func_72980_b(var21, var22, var23, "liquid.lavapop", 0.2f + par5Random.nextFloat() * 0.2f, 0.9f + par5Random.nextFloat() * 0.15f, false);
            }
            if (par5Random.nextInt(200) == 0) {
                par1World.func_72980_b((double)par2, (double)par3, (double)par4, "liquid.lava", 0.2f + par5Random.nextFloat() * 0.2f, 0.9f + par5Random.nextFloat() * 0.15f, false);
            }
        }
        if (par5Random.nextInt(10) == 0 && par1World.func_72797_t(par2, par3 - 1, par4) && !par1World.func_72803_f(par2, par3 - 2, par4).func_76230_c()) {
            double var21 = (float)par2 + par5Random.nextFloat();
            var22 = (double)par3 - 1.05;
            double var23 = (float)par4 + par5Random.nextFloat();
            par1World.func_72869_a("dripLava", var21, var22, var23, 0.0, 0.0, 0.0);
        }
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
    }
}

