/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.tinker.tconstruct.TConstruct;
import mods.tinker.tconstruct.blocks.logic.DrawbridgeLogic;
import mods.tinker.tconstruct.blocks.logic.FirestarterLogic;
import mods.tinker.tconstruct.client.block.MachineRender;
import mods.tinker.tconstruct.common.TProxyCommon;
import mods.tinker.tconstruct.library.TConstructRegistry;
import mods.tinker.tconstruct.library.blocks.InventoryBlock;
import mods.tinker.tconstruct.library.util.IActiveLogic;
import mods.tinker.tconstruct.library.util.IFacingLogic;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class RedstoneMachine
extends InventoryBlock {
    public RedstoneMachine(int id) {
        super(id, Material.field_76243_f);
        this.func_71849_a(TConstructRegistry.blockTab);
        this.func_71848_c(12.0f);
        this.func_71884_a(field_71977_i);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity logic;
        if (world.func_72805_g(x, y, z) == 0 && (logic = world.func_72796_p(x, y, z)) != null && logic instanceof DrawbridgeLogic && ((DrawbridgeLogic)logic).func_70301_a(1) != null) {
            ItemStack stack = ((DrawbridgeLogic)logic).func_70301_a(1);
            if (stack.field_77993_c < 4096 && Block.field_71973_m[stack.field_77993_c] != null) {
                return field_71984_q[stack.field_77993_c];
            }
        }
        return super.getLightValue(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71920_b(IBlockAccess world, int x, int y, int z) {
        ItemStack stack;
        TileEntity logic;
        if (world.func_72805_g(x, y, z) == 0 && (logic = world.func_72796_p(x, y, z)) != null && logic instanceof DrawbridgeLogic && (stack = ((DrawbridgeLogic)logic).func_70301_a(1)) != null && stack.field_77993_c < 4096 && Block.field_71973_m[stack.field_77993_c] != null) {
            return Block.field_71973_m[stack.field_77993_c].func_71920_b(world, x, y, z);
        }
        return 0xFFFFFF;
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new DrawbridgeLogic();
            }
            case 1: {
                return new FirestarterLogic();
            }
        }
        return null;
    }

    @Override
    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 0: {
                return TProxyCommon.drawbridgeID;
            }
        }
        return null;
    }

    @Override
    public Object getModInstance() {
        return TConstruct.instance;
    }

    @Override
    public String[] getTextureNames() {
        String[] textureNames = new String[]{"drawbridge_top", "drawbridge_side", "drawbridge_bottom", "drawbridge_top_face", "drawbridge_side_face", "drawbridge_bottom_face", "firestarter_top", "firestarter_side", "firestarter_bottom"};
        return textureNames;
    }

    @Override
    public void func_94332_a(IconRegister iconRegister) {
        String[] textureNames = this.getTextureNames();
        this.icons = new Icon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("tinker:machines/" + textureNames[i]);
        }
    }

    public Icon func_71858_a(int side, int meta) {
        if (meta == 0) {
            if (side == 5) {
                return this.icons[5];
            }
            return this.icons[this.getTextureIndex(side)];
        }
        if (meta == 1) {
            return this.icons[this.getTextureIndex(side) + 6];
        }
        return this.icons[0];
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity logic = world.func_72796_p(x, y, z);
        int direction = logic instanceof IFacingLogic ? (int)((IFacingLogic)logic).getRenderDirection() : 0;
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            Block block;
            DrawbridgeLogic drawbridge = (DrawbridgeLogic)logic;
            ItemStack stack = drawbridge.func_70301_a(1);
            if (stack != null && stack.field_77993_c < 4096 && (block = Block.field_71973_m[stack.field_77993_c]) != null && block.func_71886_c()) {
                return block.func_71858_a(side, stack.func_77960_j());
            }
            if (side == direction) {
                return this.icons[this.getTextureIndex(side) + 3];
            }
            return this.icons[this.getTextureIndex(side)];
        }
        if (meta == 1) {
            if (side == direction) {
                return this.icons[6];
            }
            if (side / 2 == direction / 2) {
                return this.icons[8];
            }
            return this.icons[7];
        }
        return this.icons[0];
    }

    public int getTextureIndex(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return 1;
    }

    public int func_71857_b() {
        return MachineRender.model;
    }

    public boolean isFireSource(World world, int x, int y, int z, int metadata, ForgeDirection side) {
        if (metadata == 1) {
            return side == ForgeDirection.UP;
        }
        return false;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 2; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int neighborBlockID) {
        IActiveLogic logic = (IActiveLogic)world.func_72796_p(x, y, z);
        logic.setActive(world.func_72864_z(x, y, z) || this.activeNearbyRedstone(world, x, y, z));
    }

    boolean activeNearbyRedstone(World world, int x, int y, int z) {
        return this.activeRedstone(world, x + 1, y, z) || this.activeRedstone(world, x - 1, y, z) || this.activeRedstone(world, x, y, z + 1) || this.activeRedstone(world, x, y, z - 1);
    }

    boolean activeRedstone(World world, int x, int y, int z) {
        Block wire = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (wire != null && wire.field_71990_ca == Block.field_72075_av.field_71990_ca) {
            return world.func_72805_g(x, y, z) > 0;
        }
        return false;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.func_71020_j(0.025f);
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            ItemStack camo;
            ItemStack stack = new ItemStack(this.field_71990_ca, 1, meta);
            DrawbridgeLogic logic = (DrawbridgeLogic)world.func_72796_p(x, y, z);
            NBTTagCompound tag = new NBTTagCompound();
            boolean hasTag = false;
            ItemStack contents = logic.func_70301_a(0);
            if (contents != null) {
                NBTTagCompound contentTag = new NBTTagCompound();
                contents.func_77955_b(contentTag);
                tag.func_74766_a("Contents", contentTag);
                hasTag = true;
            }
            if ((camo = logic.func_70301_a(1)) != null) {
                NBTTagCompound camoTag = new NBTTagCompound();
                camo.func_77955_b(camoTag);
                tag.func_74766_a("Camoflauge", camoTag);
                hasTag = true;
            }
            if (logic.getPlacementDirection() != 4) {
                tag.func_74774_a("Placement", logic.getPlacementDirection());
                hasTag = true;
            }
            if (hasTag) {
                stack.func_77982_d(tag);
            }
            this.dropDrawbridgeLogic(world, x, y, z, stack);
        }
        return world.func_94571_i(x, y, z);
    }

    protected void dropDrawbridgeLogic(World world, int x, int y, int z, ItemStack stack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack);
            entityitem.field_70293_c = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public void func_71893_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        if (meta != 0) {
            super.func_71893_a(world, player, x, y, z, meta);
        }
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLiving living, ItemStack stack) {
        super.func_71860_a(world, x, y, z, living, stack);
        if (stack.func_77942_o()) {
            NBTTagCompound camoTag;
            DrawbridgeLogic logic = (DrawbridgeLogic)world.func_72796_p(x, y, z);
            NBTTagCompound contentTag = stack.func_77978_p().func_74775_l("Contents");
            if (contentTag != null) {
                ItemStack contents = ItemStack.func_77949_a((NBTTagCompound)contentTag);
                logic.func_70299_a(0, contents);
            }
            if ((camoTag = stack.func_77978_p().func_74775_l("Camoflauge")) != null) {
                ItemStack camoflauge = ItemStack.func_77949_a((NBTTagCompound)camoTag);
                logic.func_70299_a(1, camoflauge);
            }
            if (stack.func_77978_p().func_74764_b("Placement")) {
                logic.setPlacementDirection(stack.func_77978_p().func_74771_c("Placement"));
            }
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }
}

