/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks;

import java.util.List;
import mods.tinker.tconstruct.blocks.logic.LavaTankLogic;
import mods.tinker.tconstruct.client.block.TankRender;
import mods.tinker.tconstruct.library.TConstructRegistry;
import mods.tinker.tconstruct.library.util.IServantLogic;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class LavaTankBlock
extends BlockContainer {
    public Icon[] icons;

    public LavaTankBlock(int id) {
        super(id, Material.field_76246_e);
        this.func_71848_c(12.0f);
        this.func_71849_a(TConstructRegistry.blockTab);
        this.func_71864_b("TConstruct.LavaTank");
        this.func_71884_a(Block.field_71974_j);
    }

    public String[] getTextureNames() {
        String[] textureNames = new String[]{"lavatank_side", "lavatank_top", "searedgague_top", "searedgague_side", "searedgague_bottom", "searedwindow_top", "searedwindow_side", "searedwindow_bottom"};
        return textureNames;
    }

    public void func_94332_a(IconRegister iconRegister) {
        String[] textureNames = this.getTextureNames();
        this.icons = new Icon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("tinker:" + textureNames[i]);
        }
    }

    public int func_71856_s_() {
        return 1;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71877_c(IBlockAccess world, int x, int y, int z, int side) {
        int bID = world.func_72798_a(x, y, z);
        return bID == this.field_71990_ca ? false : super.func_71877_c(world, x, y, z, side);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity logic = world.func_72796_p(x, y, z);
        if (logic != null && logic instanceof LavaTankLogic) {
            return ((LavaTankLogic)logic).getBrightness();
        }
        return 0;
    }

    public int func_71857_b() {
        return TankRender.tankModelID;
    }

    public Icon func_71858_a(int side, int meta) {
        if (meta >= 3) {
            meta = 0;
        }
        if (meta == 0) {
            if (side == 0 || side == 1) {
                return this.icons[1];
            }
            return this.icons[0];
        }
        return this.icons[meta * 3 + this.getTextureIndex(side) - 1];
    }

    public int getTextureIndex(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return 1;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new LavaTankLogic();
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        ItemStack heldItem = player.field_71071_by.func_70448_g();
        if (heldItem != null) {
            LiquidStack liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)player.func_71045_bC());
            LavaTankLogic logic = (LavaTankLogic)world.func_72796_p(x, y, z);
            if (liquid != null) {
                int amount = logic.fill(0, liquid, false);
                if (amount == liquid.amount) {
                    logic.fill(ForgeDirection.UNKNOWN, liquid, true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, LavaTankBlock.consumeItem(heldItem));
                    }
                    return true;
                }
                return true;
            }
            if (LiquidContainerRegistry.isBucket((ItemStack)heldItem)) {
                ILiquidTank[] tanks = logic.getTanks(ForgeDirection.UNKNOWN);
                LiquidStack fillLiquid = tanks[0].getLiquid();
                ItemStack fillStack = LiquidContainerRegistry.fillLiquidContainer((LiquidStack)fillLiquid, (ItemStack)heldItem);
                if (fillStack != null) {
                    logic.drain(ForgeDirection.UNKNOWN, LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)fillStack).amount, true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (heldItem.field_77994_a == 1) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, fillStack);
                        } else {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, LavaTankBlock.consumeItem(heldItem));
                            if (!player.field_71071_by.func_70441_a(fillStack)) {
                                player.func_71021_b(fillStack);
                            }
                        }
                    }
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().func_77634_r()) {
                return stack.func_77973_b().getContainerItemStack(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    public TileEntity func_72274_a(World world) {
        return this.createTileEntity(world, 0);
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 3; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.func_71020_j(0.025f);
        int meta = world.func_72805_g(x, y, z);
        ItemStack stack = new ItemStack(this.field_71990_ca, 1, meta);
        LavaTankLogic logic = (LavaTankLogic)world.func_72796_p(x, y, z);
        LiquidStack liquid = logic.tank.getLiquid();
        if (liquid != null) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound liquidTag = new NBTTagCompound();
            liquid.writeToNBT(liquidTag);
            tag.func_74766_a("Liquid", liquidTag);
            stack.func_77982_d(tag);
        }
        if (!player.field_71075_bZ.field_75098_d || player.func_70093_af()) {
            this.dropTankBlock(world, x, y, z, stack);
        }
        return world.func_94571_i(x, y, z);
    }

    protected void dropTankBlock(World world, int x, int y, int z, ItemStack stack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack);
            entityitem.field_70293_c = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public void func_71893_a(World par1World, EntityPlayer par2EntityPlayer, int par3, int par4, int par5, int par6) {
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving living, ItemStack stack) {
        NBTTagCompound liquidTag;
        if (stack.func_77942_o() && (liquidTag = stack.func_77978_p().func_74775_l("Liquid")) != null) {
            LiquidStack liquid = LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)liquidTag);
            LavaTankLogic logic = (LavaTankLogic)world.func_72796_p(x, y, z);
            logic.tank.setLiquid(liquid);
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int nBlockID) {
        TileEntity logic = world.func_72796_p(x, y, z);
        if (logic instanceof IServantLogic) {
            ((IServantLogic)logic).notifyMasterOfChange();
        }
    }
}

