/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks;

import java.util.List;
import mods.tinker.tconstruct.blocks.logic.CrystalLogic;
import mods.tinker.tconstruct.blocks.logic.LightAggregator;
import mods.tinker.tconstruct.client.block.CrystalBlockRender;
import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.crystal.Crystallinity;
import mods.tinker.tconstruct.library.TConstructRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CrystalBlock
extends BlockContainer {
    String[] textureNames = new String[]{"lightstone"};
    Icon[] icons;

    public CrystalBlock(int id) {
        super(id, Material.field_76264_q);
        this.func_71849_a(TConstructRegistry.blockTab);
    }

    public Icon func_71858_a(int side, int meta) {
        return this.icons[0];
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public int func_71857_b() {
        return CrystalBlockRender.model;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 16; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public void func_94332_a(IconRegister iconRegister) {
        this.icons = new Icon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("tinker:machines/" + this.textureNames[i]);
        }
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new CrystalLogic();
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity logic;
        if (world.func_72805_g(x, y, z) == 0 && (logic = world.func_72796_p(x, y, z)) != null && logic instanceof CrystalLogic && ((CrystalLogic)logic).getActive()) {
            return 15;
        }
        return super.getLightValue(world, x, y, z);
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.func_71020_j(0.025f);
        int meta = world.func_72805_g(x, y, z);
        if (meta <= 5) {
            TileEntity aggregator;
            ItemStack stack = new ItemStack(this.field_71990_ca, 1, 0);
            CrystalLogic logic = (CrystalLogic)world.func_72796_p(x, y, z);
            NBTTagCompound tag = new NBTTagCompound();
            int value = logic.getCrystalValue();
            tag.func_74768_a("Value", value);
            Crystallinity.updateTheft(world.field_73011_w.field_76574_g, x, z, -value, Crystallinity.CrystalType.Light);
            stack.func_77982_d(tag);
            if (logic.growing() && (aggregator = world.func_72796_p(x, y - 1, z)) instanceof LightAggregator) {
                ((LightAggregator)aggregator).harvestCrystal();
            }
            for (int i = 0; i < CrystalBlock.getCrystalHeight(value); ++i) {
                world.func_94571_i(x, y + i, z);
            }
            if (!player.field_71075_bZ.field_75098_d || player.func_70093_af()) {
                this.dropBlock(world, x, y, z, stack);
            }
        } else {
            Block below = Block.field_71973_m[world.func_72798_a(x, y - 1, z)];
            if (below == TContent.lightCrystalBase) {
                below.removeBlockByPlayer(world, player, x, y - 1, z);
            } else {
                world.func_94571_i(x, y, z);
            }
        }
        return true;
    }

    public static int getCrystalHeight(int crystalValue) {
        if (crystalValue > 440) {
            return 4;
        }
        if (crystalValue > 224) {
            return 3;
        }
        if (crystalValue > 80) {
            return 2;
        }
        return 1;
    }

    protected void dropBlock(World world, int x, int y, int z, ItemStack stack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack);
            entityitem.field_70293_c = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public void func_71893_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving living, ItemStack stack) {
        CrystalLogic logic = (CrystalLogic)world.func_72796_p(x, y, z);
        logic.setActive(true);
        if (stack.func_77942_o()) {
            int value = stack.func_77978_p().func_74762_e("Value");
            Crystallinity.updateTheft(world.field_73011_w.field_76574_g, x, z, value, Crystallinity.CrystalType.Light);
            logic.setCrystalValue(value);
        }
    }
}

