/*
 * Decompiled with CFR 0.152.
 */
package magicbees.world;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.Random;
import magicbees.main.MagicBees;
import magicbees.main.utils.ChunkCoords;
import magicbees.world.WorldTicker;
import magicbees.world.feature.FeatureHive;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkDataEvent;

public class WorldGeneratorHandler
implements IWorldGenerator {
    public WorldTicker ticker = new WorldTicker(this);

    public WorldGeneratorHandler() {
        TickRegistry.registerTickHandler((ITickHandler)this.ticker, (Side)Side.SERVER);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FeatureHive.initialize();
    }

    @ForgeSubscribe
    public void chunkSaveEventHandler(ChunkDataEvent.Save event) {
        NBTTagCompound tag = new NBTTagCompound();
        if (MagicBees.getConfig().DoHiveRetrogen) {
            tag.func_74757_a("hiveRetrogen", true);
        }
        event.getData().func_74782_a("MagicBees", (NBTBase)tag);
    }

    @ForgeSubscribe
    public void chunkLoadEventHandler(ChunkDataEvent.Load event) {
        boolean doRetrogen = false;
        NBTTagCompound tag = (NBTTagCompound)event.getData().func_74781_a("MagicBees");
        if (tag == null) {
            doRetrogen = true;
        } else if (!tag.func_74764_b("hiveRetrogen") || MagicBees.getConfig().ForceHiveRegen) {
            doRetrogen = true;
        }
        if (doRetrogen) {
            ChunkCoords coords = new ChunkCoords(event.getChunk());
            this.ticker.queueChunkCoords(coords);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.generateWorld(world, random, chunkX, chunkZ, true);
    }

    public void generateWorld(World world, Random random, int chunkX, int chunkZ, boolean initialGen) {
        boolean modified = false;
        if (world.field_73011_w.field_76577_b != WorldType.field_77138_c && (initialGen || MagicBees.getConfig().DoHiveRetrogen)) {
            FeatureHive.generateHives(world, random, chunkX, chunkZ, initialGen);
            modified = true;
        }
        if (!initialGen && modified) {
            world.func_72964_e(chunkX, chunkZ).func_76630_e();
        }
    }
}

