/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import magicbees.main.utils.TickHandlerVersion;

public class VersionInfo {
    public static final String ModName = "MagicBees";
    public static final String Version = "2.1.1";
    public static final String Build = "40";
    public static final String MCVersion = "1.5.2";
    public static final String VersionURL = "http://bit.ly/magicbeesVersionInfo";
    public static final String Logo = "/gfx/magicbees/logo.png";
    public static final String Depends = "required-after:Forestry;after:Thaumcraft;after:ExtraBees;after:EE3;after:ArsMagica;after:TConstruct";
    boolean criticalUpdate;
    boolean newVersion;
    boolean newMinecraftVersion;
    boolean versionCheckComplete;
    String latestModVersion;
    String latestMCVersion = "1.5.2";
    String description = "";
    String modName;
    String modVersion;
    String releaseURL;
    Logger modLogger = FMLLog.getLogger();

    public static int[] parseVersion(String rawVersion) {
        ArrayList<Integer> versionTokens = new ArrayList<Integer>();
        String[] tokens = rawVersion.trim().split("\\.");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
            if (tokens[i].matches("[0-9]+")) {
                versionTokens.add(Integer.valueOf(tokens[i]));
                continue;
            }
            if (!tokens[i].matches("[0-9]+[a-z]")) continue;
            String numberString = tokens[i].substring(0, tokens[i].length() - 1);
            versionTokens.add(Integer.valueOf(numberString));
            versionTokens.add(Character.getNumericValue(tokens[i].charAt(tokens[i].length() - 1)));
        }
        int[] value = new int[versionTokens.size()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = (Integer)versionTokens.get(i);
        }
        return value;
    }

    public static boolean beforeTargetVersion(String version, String target) {
        boolean result = false;
        int[] versionTokens = VersionInfo.parseVersion(version);
        int[] targetTokens = VersionInfo.parseVersion(target);
        for (int i = 0; i < versionTokens.length && i < targetTokens.length; ++i) {
            if (versionTokens[i] < targetTokens[i]) {
                result = true;
                break;
            }
            if (versionTokens[i] > targetTokens[i]) {
                result = false;
                break;
            }
            if (i != versionTokens.length - 1 || versionTokens.length >= targetTokens.length) continue;
            result = true;
        }
        return result;
    }

    public static boolean afterTargetVersion(String version, String target) {
        boolean result = false;
        int[] versionTokens = VersionInfo.parseVersion(version);
        int[] targetTokens = VersionInfo.parseVersion(target);
        for (int i = 0; i < versionTokens.length && i < targetTokens.length; ++i) {
            if (versionTokens[i] <= targetTokens[i]) continue;
            result = true;
            break;
        }
        return result;
    }

    public VersionInfo(String name, String version, String url) {
        this.modName = name;
        this.modVersion = this.latestModVersion = version;
        this.releaseURL = url;
    }

    public VersionInfo(String name, String version, String url, Logger logger) {
        this.modName = name;
        this.modVersion = this.latestModVersion = version;
        this.releaseURL = url;
        this.modLogger = logger;
    }

    public void checkForNewVersion() {
        VersionCheckThread versionCheckThread = new VersionCheckThread();
        versionCheckThread.start();
    }

    public String getCurrentVersion() {
        return this.modVersion;
    }

    public String getLatestVersion() {
        return this.latestModVersion;
    }

    public String getLatestMCVersion() {
        return this.latestMCVersion;
    }

    public String getVersionDescription() {
        return this.description;
    }

    public boolean isCriticalUpdate() {
        return this.criticalUpdate;
    }

    public boolean isNewVersionAvailable() {
        return this.newVersion;
    }

    public boolean isMinecraftOutdated() {
        return this.newMinecraftVersion;
    }

    public boolean isVersionCheckComplete() {
        return this.versionCheckComplete;
    }

    public static void doVersionCheck() {
        VersionInfo main = new VersionInfo(ModName, Version, VersionURL);
        TickHandlerVersion.registerModVersionInfo(main);
        TickHandlerVersion.initialize();
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)TickHandlerVersion.instance, (Side)Side.CLIENT);
        VersionInfo versionInfo = main;
        versionInfo.getClass();
        VersionCheckThread thread = versionInfo.new VersionCheckThread();
        thread.start();
    }

    private class VersionCheckThread
    extends Thread {
        private VersionCheckThread() {
        }

        @Override
        public void run() {
            try {
                String location = VersionInfo.VersionURL;
                URLConnection connection = null;
                while (location != null && !location.isEmpty()) {
                    URL url = new URL(location);
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.60 Safari/537.17");
                    connection.connect();
                    location = connection.getHeaderField("Location");
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                VersionInfo.this.latestModVersion = reader.readLine();
                VersionInfo.this.criticalUpdate = Boolean.parseBoolean(reader.readLine());
                VersionInfo.this.latestMCVersion = reader.readLine();
                VersionInfo.this.description = reader.readLine();
                reader.close();
                if (VersionInfo.beforeTargetVersion(VersionInfo.this.modVersion, VersionInfo.this.latestModVersion)) {
                    VersionInfo.this.modLogger.log(Level.INFO, "An updated version of " + VersionInfo.this.modName + " is available: " + VersionInfo.this.latestModVersion + ".");
                    VersionInfo.this.newVersion = true;
                    if (VersionInfo.this.criticalUpdate) {
                        VersionInfo.this.modLogger.log(Level.INFO, "This update has been marked as CRITICAL and will ignore notification suppression.");
                    }
                    if (VersionInfo.beforeTargetVersion(VersionInfo.MCVersion, VersionInfo.this.latestMCVersion)) {
                        VersionInfo.this.newMinecraftVersion = true;
                        VersionInfo.this.modLogger.log(Level.INFO, "This update is for Minecraft " + VersionInfo.this.latestMCVersion + ".");
                    }
                }
            }
            catch (Exception e) {
                VersionInfo.this.modLogger.log(Level.WARNING, "Version Check Failed: " + e.getMessage());
            }
            VersionInfo.this.versionCheckComplete = true;
        }
    }
}

