/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import magicbees.bees.BeeManager;
import magicbees.client.gui.GUIHandler;
import magicbees.main.CommonProxy;
import magicbees.main.Config;
import magicbees.main.utils.CompatabilityManager;
import magicbees.main.utils.CraftingManager;
import magicbees.main.utils.LocalizationManager;
import magicbees.main.utils.VersionInfo;
import magicbees.main.utils.compat.ArsMagicaHelper;
import magicbees.main.utils.compat.EquivalentExchangeHelper;
import magicbees.main.utils.compat.ExtraBeesHelper;
import magicbees.main.utils.compat.ThaumcraftHelper;
import magicbees.world.WorldGeneratorHandler;

@Mod(modid="MagicBees", name="Magic Bees", useMetadata=true, acceptedMinecraftVersions="1.5.2", version="2.1.1", dependencies="required-after:Forestry;after:Thaumcraft;after:ExtraBees;after:EE3;after:ArsMagica;after:TConstruct")
@NetworkMod(serverSideRequired=false, clientSideRequired=true)
public class MagicBees {
    @Mod.Instance(value="MagicBees")
    public static MagicBees object;
    @SidedProxy(serverSide="magicbees.main.CommonProxy", clientSide="magicbees.main.ClientProxy")
    public static CommonProxy proxy;
    public GUIHandler guiHandler;
    private String configsPath;
    private Config modConfig;
    private WorldGeneratorHandler worldHandler;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        LocalizationManager.setupLocalizationInfo();
        this.configsPath = event.getModConfigurationDirectory().getAbsolutePath();
        this.modConfig = new Config(event.getSuggestedConfigurationFile());
        ThaumcraftHelper.init();
        ExtraBeesHelper.init();
        EquivalentExchangeHelper.init();
        ArsMagicaHelper.init();
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        this.modConfig.setupBlocks();
        this.modConfig.setupItems();
        CompatabilityManager.setupBackpacks();
        this.worldHandler = new WorldGeneratorHandler();
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.worldHandler);
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        this.guiHandler = new GUIHandler();
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)this.guiHandler);
        proxy.registerRenderers();
        BeeManager.ititializeBees();
        this.modConfig.saveConfigs();
        ThaumcraftHelper.setupItemAspects();
        CraftingManager.setupCrafting();
        ThaumcraftHelper.setupResearch();
        VersionInfo.doVersionCheck();
    }

    public static Config getConfig() {
        return MagicBees.object.modConfig;
    }
}

