/*
 * Decompiled with CFR 0.152.
 */
package magicbees.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import magicbees.item.types.CapsuleType;
import magicbees.item.types.LiquidType;
import magicbees.main.utils.TabMagicBees;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class ItemCapsule
extends Item {
    private CapsuleType capsuleType;

    public ItemCapsule(CapsuleType type, int itemId, int maxStackSize) {
        super(itemId);
        this.capsuleType = type;
        this.func_77637_a(TabMagicBees.tabMagicBees);
        this.func_77627_a(true);
        this.func_77625_d(maxStackSize);
        this.func_77655_b("capsule." + type.toString().toLowerCase());
        GameRegistry.registerItem((Item)this, (String)("capsule." + type.toString().toLowerCase()));
    }

    public CapsuleType getType() {
        return this.capsuleType;
    }

    public String func_77628_j(ItemStack itemStack) {
        return String.format(this.capsuleType.getLocalizedName(), LiquidType.values()[itemStack.func_77960_j()].getDisplayName());
    }

    public ItemStack getCapsuleForLiquid(LiquidType l) {
        return new ItemStack((Item)this, 1, l.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int par1, CreativeTabs tab, List itemList) {
        for (LiquidType l : LiquidType.values()) {
            if (!l.available) continue;
            itemList.add(new ItemStack((Item)this, 1, l.ordinal()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("MagicBees".toLowerCase() + ":capsule" + this.capsuleType.getName().substring(0, 1).toUpperCase() + this.capsuleType.getName().substring(1));
        for (LiquidType t : LiquidType.values()) {
            if (t == LiquidType.EMPTY || t.liquidIcon != null) continue;
            t.liquidIcon = par1IconRegister.func_94245_a("MagicBees".toLowerCase() + ":liquids/" + t.liquidID);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77618_c(int metadata, int pass) {
        Icon i = this.field_77791_bV;
        if (metadata != 0 && pass == 0) {
            i = LiquidType.values()[Math.max((int)0, (int)Math.min((int)metadata, (int)(LiquidType.values().length - 1)))].liquidIcon;
        }
        return i;
    }

    public int getRenderPasses(int metadata) {
        return metadata == 0 ? 1 : 2;
    }
}

