/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.core.ItemInterface;
import forestry.api.genetics.IAllele;
import magicbees.bees.Allele;
import magicbees.bees.AlleleFlower;
import magicbees.bees.BeeSpecies;
import magicbees.main.utils.compat.ExtraBeesHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class BeeGenomeManager {
    private static IAllele[] getTemplateModBase() {
        IAllele[] genome = new IAllele[EnumBeeChromosome.values().length];
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.MYSTICAL;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedSlowest");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanShorter");
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityNormal");
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceNone");
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolFalse");
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceNone");
        genome[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = Allele.getBaseAllele("boolFalse");
        genome[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.getBaseAllele("boolFalse");
        genome[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.getBaseAllele("flowersVanilla");
        genome[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.getBaseAllele("floweringSlowest");
        genome[EnumBeeChromosome.TERRITORY.ordinal()] = Allele.getBaseAllele("territoryDefault");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.getBaseAllele("effectNone");
        return genome;
    }

    public static IAllele[] addRainResist(IAllele[] genome) {
        genome[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = Allele.getBaseAllele("boolTrue");
        return genome;
    }

    public static IAllele[] getTemplateMystical() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.MYSTICAL;
        return genome;
    }

    public static IAllele[] getTemplateSorcerous() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.SORCEROUS;
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityHigh");
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceDown2");
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceDown1");
        return genome;
    }

    public static IAllele[] getTemplateUnusual() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.UNUSUAL;
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth2");
        return genome;
    }

    public static IAllele[] getTemplateAttuned() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.ATTUNED;
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityHigh");
        return genome;
    }

    public static IAllele[] getTemplateEldritch() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.ELDRITCH;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedSlower");
        return genome;
    }

    private static IAllele[] getTemplateBaseArcane() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth1");
        genome[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.getBaseAllele("floweringSlow");
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityHigh");
        return genome;
    }

    public static IAllele[] getTemplateEsoteric() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseArcane();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.ESOTERIC;
        return genome;
    }

    public static IAllele[] getTemplateMysterious() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseArcane();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.MYSTERIOUS;
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth2");
        return genome;
    }

    public static IAllele[] getTemplateArcane() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseArcane();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.ARCANE;
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth2");
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityNormal");
        genome[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.getBaseAllele("floweringAverage");
        return genome;
    }

    private static IAllele[] getTemplateBaseSupernatural() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedNorm");
        genome[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.getBaseAllele("floweringSlowest");
        return genome;
    }

    public static IAllele[] getTemplateCharmed() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseSupernatural();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.CHARMED;
        return genome;
    }

    public static IAllele[] getTemplateEnchanted() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseSupernatural();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.ENCHANTED;
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth1");
        return genome;
    }

    public static IAllele[] getTemplateSupernatural() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseSupernatural();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.SUPERNATURAL;
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth2");
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth1");
        return genome;
    }

    public static IAllele[] getTemplateEthereal() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.ETHEREAL;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedNorm");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanShortened");
        genome[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.getBaseAllele("floweringAverage");
        return genome;
    }

    private static IAllele[] getTemplateBaseElemental() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedNorm");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanNormal");
        return genome;
    }

    public static IAllele[] getTemplateWatery() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseElemental();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.WATERY;
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceUp1");
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceDown2");
        genome[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.getBaseAllele("flowersSnow");
        return genome;
    }

    public static IAllele[] getTemplateFirey() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseElemental();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.FIREY;
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceDown1");
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceUp2");
        genome[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.getBaseAllele("flowersCacti");
        return genome;
    }

    public static IAllele[] getTemplateEarthy() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseElemental();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.EARTHY;
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth1");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanLong");
        return genome;
    }

    public static IAllele[] getTemplateWindy() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseElemental();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.WINDY;
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth2");
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedFaster");
        genome[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.getBaseAllele("floweringFaster");
        return genome;
    }

    private static IAllele[] getTemplateBaseScholarly() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedSlow");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanElongated");
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceUp2");
        genome[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = AlleleFlower.flowerBookshelf;
        return genome;
    }

    public static IAllele[] getTemplatePupil() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseScholarly();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.PUPIL;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedSlower");
        return genome;
    }

    public static IAllele[] getTemplateScholarly() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseScholarly();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.SCHOLARLY;
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityLow");
        return genome;
    }

    public static IAllele[] getTemplateSavant() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseScholarly();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.SAVANT;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedNorm");
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityLow");
        return genome;
    }

    private static IAllele[] getTemplateBaseSoul() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth1");
        genome[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = Allele.getBaseAllele("boolTrue");
        return genome;
    }

    public static IAllele[] getTemplateAware() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseSoul();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.AWARE;
        return genome;
    }

    public static IAllele[] getTemplateSpirit() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseSoul();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.SPIRIT;
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanShortened");
        return genome;
    }

    public static IAllele[] getTemplateSoul() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseSoul();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.SOUL;
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceDown2");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanNormal");
        return genome;
    }

    private static IAllele[] getTemplateBaseMalevolent() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedFast");
        genome[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.getBaseAllele("floweringFaster");
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityNormal");
        return genome;
    }

    public static IAllele[] getTemplateSkulking() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMalevolent();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.SKULKING;
        genome[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.getBaseAllele("boolTrue");
        return genome;
    }

    public static IAllele[] getTemplateGhastly() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMalevolent();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.GHASTLY;
        genome[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth1");
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityLow");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.spawnGhast;
        return genome;
    }

    public static IAllele[] getTemplateSpidery() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMalevolent();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.SPIDERY;
        genome[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.TERRITORY.ordinal()] = Allele.getBaseAllele("territoryLarger");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.spawnSpider;
        return genome;
    }

    public static IAllele[] getTemplateSmouldering() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMalevolent();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.SMOULDERING;
        genome[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.spawnBlaze;
        return genome;
    }

    private static IAllele[] getTemplateBaseTemporal() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth1");
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityNormal");
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedNorm");
        genome[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = Allele.getBaseAllele("boolTrue");
        return genome;
    }

    public static IAllele[] getTemplateTimely() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseTemporal();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TIMELY;
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectSlowSpeed;
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanElongated");
        return genome;
    }

    public static IAllele[] getTemplateLordly() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseTemporal();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.LORDLY;
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectSlowSpeed;
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanLong");
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.getBaseAllele("effectDrunkard");
        return genome;
    }

    public static IAllele[] getTemplateDoctoral() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseTemporal();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.DOCTORAL;
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectSlowSpeed;
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth3");
        genome[EnumBeeChromosome.TERRITORY.ordinal()] = Allele.getBaseAllele("territoryLarge");
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanLongest");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.getBaseAllele("effectHeroic");
        return genome;
    }

    private static IAllele[] getTemplateAbominableBase() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.INFERNAL;
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceDown2");
        genome[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.getBaseAllele("flowersNether");
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.getBaseAllele("effectAggressive");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanShort");
        return genome;
    }

    public static IAllele[] getTemplateInfernal() {
        IAllele[] genome = BeeGenomeManager.getTemplateAbominableBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.INFERNAL;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedSlow");
        return genome;
    }

    public static IAllele[] getTemplateHateful() {
        IAllele[] genome = BeeGenomeManager.getTemplateAbominableBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.HATEFUL;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedSlow");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanElongated");
        genome[EnumBeeChromosome.TERRITORY.ordinal()] = Allele.getBaseAllele("territoryLarger");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.getBaseAllele("effectMisanthrope");
        return genome;
    }

    public static IAllele[] getTemplateSpiteful() {
        IAllele[] genome = BeeGenomeManager.getTemplateAbominableBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.SPITEFUL;
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanLong");
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedNorm");
        genome[EnumBeeChromosome.TERRITORY.ordinal()] = Allele.getBaseAllele("territoryLarger");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.getBaseAllele("effectMisanthrope");
        return genome;
    }

    public static IAllele[] getTemplateWithering() {
        IAllele[] genome = BeeGenomeManager.getTemplateAbominableBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.WITHERING;
        genome[EnumBeeChromosome.TERRITORY.ordinal()] = Allele.getBaseAllele("territoryLargest");
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityLow");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectWithering;
        return genome;
    }

    private static IAllele[] getTemplateBaseExtrinsic() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceUp2");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.getBaseAllele("effectAggressive");
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.getBaseAllele("flowersEnd");
        genome[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.getBaseAllele("boolTrue");
        return genome;
    }

    public static IAllele[] getTemplateOblivion() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseExtrinsic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.OBLIVION;
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityMaximum");
        return genome;
    }

    public static IAllele[] getTemplateNameless() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseExtrinsic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.NAMELESS;
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityHigh");
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth1");
        return genome;
    }

    public static IAllele[] getTemplateAbandoned() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseExtrinsic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.ABANDONED;
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth1");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanElongated");
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityNormal");
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedSlow");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.getBaseAllele("effectRepulsion");
        return genome;
    }

    public static IAllele[] getTemplateForlorn() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseExtrinsic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.FORLORN;
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityLow");
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth1");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanLongest");
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedSlow");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.getBaseAllele("effectRepulsion");
        return genome;
    }

    public static IAllele[] getTemplateDraconic() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseExtrinsic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.DRACONIC;
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth1");
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityLow");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanLongest");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.getBaseAllele("effectMisanthrope");
        return genome;
    }

    private static IAllele[] getTemplateBaseMetallic() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedSlowest");
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityLow");
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.getBaseAllele("boolTrue");
        return genome;
    }

    public static IAllele[] getTemplateIron() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMetallic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.IRON;
        return genome;
    }

    public static IAllele[] getTemplateGold() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMetallic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.GOLD;
        return genome;
    }

    public static IAllele[] getTemplateCopper() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMetallic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.COPPER;
        return genome;
    }

    public static IAllele[] getTemplateTin() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMetallic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TIN;
        return genome;
    }

    public static IAllele[] getTemplateSilver() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMetallic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.SILVER;
        return genome;
    }

    public static IAllele[] getTemplateLead() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMetallic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.LEAD;
        return genome;
    }

    public static IAllele[] getTemplateAluminum() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMetallic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.ALUMINUM;
        return genome;
    }

    public static IAllele[] getTemplateArdite() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMetallic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.ARDITE;
        return genome;
    }

    public static IAllele[] getTemplateCobalt() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMetallic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.COBALT;
        return genome;
    }

    public static IAllele[] getTemplateManyullyn() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMetallic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.MANYULLYN;
        return genome;
    }

    public static IAllele[] getTemplateDiamond() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMetallic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.DIAMOND;
        return genome;
    }

    public static IAllele[] getTemplateEmerald() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMetallic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.EMERALD;
        return genome;
    }

    public static IAllele[] getTemplateApatite() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMetallic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.APATITE;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedNorm");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanNormal");
        return genome;
    }

    private static IAllele[] getTemplateTCBase() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = AlleleFlower.flowerThaumcraft;
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityLow");
        return genome;
    }

    public static IAllele[] getTemplateTCStark() {
        IAllele[] genome = BeeGenomeManager.getTemplateTCBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_STARK;
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityNormal");
        return genome;
    }

    public static IAllele[] getTemplateTCAir() {
        IAllele[] genome = BeeGenomeManager.getTemplateTCBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_AIR;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedFastest");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanShortened");
        genome[EnumBeeChromosome.TERRITORY.ordinal()] = Allele.getBaseAllele("territoryLargest");
        genome[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.getBaseAllele("floweringMaximum");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectMoveSpeed;
        return genome;
    }

    public static IAllele[] getTemplateTCFire() {
        IAllele[] genome = BeeGenomeManager.getTemplateTCBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_FIRE;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedFaster");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanNormal");
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceDown3");
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceUp2");
        genome[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.getBaseAllele("effectIgnition");
        return genome;
    }

    public static IAllele[] getTemplateTCWater() {
        IAllele[] genome = BeeGenomeManager.getTemplateTCBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_WATER;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedFast");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanLong");
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceDown2");
        genome[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.TERRITORY.ordinal()] = Allele.getBaseAllele("territoryLarge");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectCleansing;
        return genome;
    }

    public static IAllele[] getTemplateTCEarth() {
        IAllele[] genome = BeeGenomeManager.getTemplateTCBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_EARTH;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedSlow");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanLonger");
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceDown1");
        genome[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.getBaseAllele("floweringFastest");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectDigSpeed;
        return genome;
    }

    public static IAllele[] getTemplateTCMagic() {
        IAllele[] genome = BeeGenomeManager.getTemplateTCBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_MAGIC;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedNorm");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanNormal");
        return genome;
    }

    private static IAllele[] getTemplateTCBaseVis() {
        IAllele[] genome = BeeGenomeManager.getTemplateTCBase();
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityLow");
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth1");
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth1");
        return genome;
    }

    public static IAllele[] getTemplateTCVis() {
        IAllele[] genome = BeeGenomeManager.getTemplateTCBaseVis();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_VIS;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedSlow");
        genome[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.getBaseAllele("floweringSlower");
        genome[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.flowerAuraNode;
        return genome;
    }

    public static IAllele[] getTemplateTCFlux() {
        IAllele[] genome = BeeGenomeManager.getTemplateTCBaseVis();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_FLUX;
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceNone");
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceNone");
        genome[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.flowerAuraNode;
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectNodeFlux;
        return genome;
    }

    public static IAllele[] getTemplateTCAttract() {
        IAllele[] genome = BeeGenomeManager.getTemplateTCBaseVis();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_ATTRACT;
        genome[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.flowerAuraNode;
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectNodeAttract;
        return genome;
    }

    public static IAllele[] getTemplateTCPure() {
        IAllele[] genome = BeeGenomeManager.getTemplateTCBaseVis();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_PURE;
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceNone");
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceNone");
        genome[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.getBaseAllele("floweringAverage");
        genome[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.flowerAuraNode;
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectNodePurify;
        return genome;
    }

    public static IAllele[] getTemplateTCRejuvinating() {
        IAllele[] genome = BeeGenomeManager.getTemplateTCBaseVis();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_REJUVENATING;
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.effectNodeCharge;
        genome[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.flowerAuraNode;
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceNone");
        return genome;
    }

    public static IAllele[] getTemplateTCBrainy() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMalevolent();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_BRAINY;
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.spawnBrainyZombie;
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityLow");
        return genome;
    }

    public static IAllele[] getTemplateTCWispy() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMalevolent();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_WISPY;
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.spawnWisp;
        genome[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityLow");
        genome[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.flowerThaumcraft;
        return genome;
    }

    public static IAllele[] getTemplateTCBatty() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMalevolent();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_BATTY;
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.spawnBats;
        genome[EnumBeeChromosome.TERRITORY.ordinal()] = Allele.getBaseAllele("territoryLarge");
        return genome;
    }

    public static IAllele[] getTemplateTCChicken() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMetallic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_CHICKEN;
        return genome;
    }

    public static IAllele[] getTemplateTCBeef() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMetallic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_BEEF;
        return genome;
    }

    public static IAllele[] getTemplateTCPork() {
        IAllele[] genome = BeeGenomeManager.getTemplateBaseMetallic();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.TC_PORK;
        return genome;
    }

    private static IAllele[] getTemplateEEBase() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.TERRITORY.ordinal()] = Allele.getBaseAllele("territoryLarge");
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedSlow");
        return genome;
    }

    public static IAllele[] getTemplateEEMinium() {
        IAllele[] genome = BeeGenomeManager.getTemplateEEBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.EE_MINIUM;
        return genome;
    }

    private static IAllele[] getTemplateAMBase() {
        IAllele[] genome = BeeGenomeManager.getTemplateModBase();
        genome[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = Allele.flowerArsMagica;
        return genome;
    }

    public static IAllele[] getTemplateAMEssence() {
        IAllele[] genome = BeeGenomeManager.getTemplateAMBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.AM_ESSENCE;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedNorm");
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityHigh");
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth1");
        genome[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.getBaseAllele("floweringSlow");
        return genome;
    }

    public static IAllele[] getTemplateAMQuintessence() {
        IAllele[] genome = BeeGenomeManager.getTemplateAMEssence();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.AM_QUINTESSENCE;
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanElongated");
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityHigh");
        genome[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.getBaseAllele("floweringAverage");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.getBaseAllele("effectMisanthrope");
        return genome;
    }

    public static IAllele[] getTemplateAMEarth() {
        IAllele[] genome = BeeGenomeManager.getTemplateAMBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.AM_EARTH;
        genome[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.getBaseAllele("floweringFaster");
        genome[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanLongest");
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityHigh");
        return genome;
    }

    public static IAllele[] getTemplateAMAir() {
        IAllele[] genome = BeeGenomeManager.getTemplateAMBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.AM_AIR;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedFast");
        genome[EnumBeeChromosome.TERRITORY.ordinal()] = Allele.getBaseAllele("territoryLargest");
        genome[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth2");
        return genome;
    }

    public static IAllele[] getTemplateAMFire() {
        IAllele[] genome = BeeGenomeManager.getTemplateAMBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.AM_FIRE;
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedNorm");
        genome[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.getBaseAllele("floweringFast");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.getBaseAllele("effectIgnition");
        return genome;
    }

    public static IAllele[] getTemplateAMWater() {
        IAllele[] genome = BeeGenomeManager.getTemplateAMBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.AM_WATER;
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceDown1");
        genome[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanElongated");
        return genome;
    }

    public static IAllele[] getTemplateAMLightning() {
        IAllele[] genome = BeeGenomeManager.getTemplateAMBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.AM_LIGHTNING;
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanShortest");
        genome[EnumBeeChromosome.TERRITORY.ordinal()] = Allele.getBaseAllele("territoryLargest");
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.speedBlinding;
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolTrue");
        if (ExtraBeesHelper.isActive()) {
            genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.getAllele("extrabees.effect.lightning");
        }
        return genome;
    }

    public static IAllele[] getTemplateAMPlant() {
        IAllele[] genome = BeeGenomeManager.getTemplateAMBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.AM_PLANT;
        genome[EnumBeeChromosome.FLOWERING.ordinal()] = Allele.getBaseAllele("floweringFastest");
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedNorm");
        genome[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth1");
        return genome;
    }

    public static IAllele[] getTemplateAMIce() {
        IAllele[] genome = BeeGenomeManager.getTemplateAMBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.AM_ICE;
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceUp2");
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceDown2");
        genome[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedSlowest");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanLongest");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.getBaseAllele("effectGlacial");
        return genome;
    }

    public static IAllele[] getTemplateAMMagma() {
        IAllele[] genome = BeeGenomeManager.getTemplateAMBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.AM_MAGMA;
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceDown2");
        genome[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanElongated");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.getBaseAllele("effectIgnition");
        return genome;
    }

    public static IAllele[] getTemplateAMArcane() {
        IAllele[] genome = BeeGenomeManager.getTemplateAMBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.AM_ARCANE;
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityLow");
        genome[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth2");
        genome[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.getBaseAllele("toleranceBoth1");
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolTrue");
        return genome;
    }

    public static IAllele[] getTemplateAMVortex() {
        IAllele[] genome = BeeGenomeManager.getTemplateAMBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.AM_VORTEX;
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.LIFESPAN.ordinal()] = Allele.getBaseAllele("lifespanLonger");
        genome[EnumBeeChromosome.FERTILITY.ordinal()] = Allele.getBaseAllele("fertilityHigh");
        genome[EnumBeeChromosome.TERRITORY.ordinal()] = Allele.getBaseAllele("territoryLarger");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.spawnManaDrainer;
        return genome;
    }

    public static IAllele[] getTemplateAMWight() {
        IAllele[] genome = BeeGenomeManager.getTemplateAMBase();
        genome[EnumBeeChromosome.SPECIES.ordinal()] = BeeSpecies.AM_WIGHT;
        genome[EnumBeeChromosome.NOCTURNAL.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = Allele.getBaseAllele("boolTrue");
        genome[EnumBeeChromosome.SPEED.ordinal()] = Allele.getBaseAllele("speedFast");
        genome[EnumBeeChromosome.EFFECT.ordinal()] = Allele.spawnWispOrHecate;
        return genome;
    }

    public static ItemStack getBeeNBTForSpecies(BeeSpecies species, EnumBeeType beeType) {
        ItemStack taggedBee;
        switch (beeType) {
            case PRINCESS: {
                taggedBee = ItemInterface.getItem((String)"beePrincessGE");
                break;
            }
            case QUEEN: {
                taggedBee = ItemInterface.getItem((String)"beeQueenGE");
                break;
            }
            default: {
                taggedBee = ItemInterface.getItem((String)"beeDroneGE");
            }
        }
        NBTTagCompound tags = new NBTTagCompound();
        BeeGenomeManager.addGeneToCompound(EnumBeeChromosome.SPECIES, (IAllele)species, tags);
        taggedBee.func_77982_d(tags);
        return taggedBee;
    }

    private static void addGeneToCompound(EnumBeeChromosome gene, IAllele allele, NBTTagCompound compound) {
        NBTTagCompound geneRoot = new NBTTagCompound();
        compound.func_74782_a("Genome", (NBTBase)geneRoot);
        NBTTagList chromosomes = new NBTTagList();
        geneRoot.func_74782_a("Chromosomes", (NBTBase)chromosomes);
        NBTTagCompound selectedGene = new NBTTagCompound();
        chromosomes.func_74742_a((NBTBase)selectedGene);
        selectedGene.func_74774_a("Slot", (byte)gene.ordinal());
        selectedGene.func_74778_a("UID0", allele.getUID());
        selectedGene.func_74778_a("UID1", allele.getUID());
    }
}

