/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.upgrade;

import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.TurtleSide;
import java.util.ArrayList;
import miscperipherals.safe.Reflector;
import miscperipherals.upgrade.UpgradeTool;
import miscperipherals.util.FakePlayer;
import miscperipherals.util.Util;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.api.ItemApi;
import thaumcraft.api.ThaumcraftApi;

public class UpgradeWand
extends UpgradeTool {
    @Override
    public int getUpgradeID() {
        return 244;
    }

    @Override
    public String getAdjective() {
        return "Wand";
    }

    @Override
    public ItemStack getCraftingItem() {
        return ItemApi.getItem((String)"itemWandCastingAdept", (int)Short.MAX_VALUE);
    }

    @Override
    public Icon getIcon(ITurtleAccess turtle, TurtleSide side) {
        return this.getCraftingItem().func_77954_c();
    }

    @Override
    public boolean attack(ITurtleAccess turtle, Entity ent) {
        if (!(ent instanceof EntityLiving)) {
            return false;
        }
        World world = turtle.getWorld();
        FakePlayer player = FakePlayer.get(world);
        player.alignToTurtle(turtle);
        ItemStack item = this.getCraftingItem();
        Integer maxvisr = (Integer)Reflector.invoke(item.func_77973_b(), "getMaxVis", Integer.class, new Object[0]);
        if (maxvisr == null) {
            return false;
        }
        int maxvis = maxvisr;
        item.field_77990_d = new NBTTagCompound();
        item.field_77990_d.func_74777_a("vis", (short)maxvis);
        player.setHeldItem(item);
        Vec3 pos = turtle.getPosition();
        if (ThaumcraftApi.decreaseClosestAura((World)world, (double)(pos.field_72450_a + 0.5), (double)(pos.field_72448_b + 0.5), (double)(pos.field_72449_c + 0.5), (int)1, (boolean)false)) {
            boolean ret = item.func_77973_b().func_77646_a(item, (EntityLiving)ent);
            int dec = maxvis - item.field_77990_d.func_74765_d("vis");
            if (dec > 0) {
                ThaumcraftApi.decreaseClosestAura((World)turtle.getWorld(), (double)(pos.field_72450_a + 0.5), (double)(pos.field_72448_b + 0.5), (double)(pos.field_72449_c + 0.5), (int)dec, (boolean)true);
            }
            if (player.func_70694_bm() == null) {
                for (TurtleSide tside : Util.TURTLE_SIDES) {
                    if (turtle.getUpgrade(tside) != this) continue;
                    Util.setTurtleUpgrade(turtle, tside, null);
                    break;
                }
            }
            return ret;
        }
        return false;
    }

    @Override
    public boolean canDig(ITurtleAccess turtle, int x, int y, int z, int side) {
        return true;
    }

    @Override
    public Iterable getBlockDrops(ITurtleAccess turtle, int x, int y, int z, int side) {
        return new ArrayList(0);
    }

    @Override
    public boolean dig(ITurtleAccess turtle, int x, int y, int z, int side) {
        World world = turtle.getWorld();
        FakePlayer player = FakePlayer.get(world);
        ItemStack item = this.getCraftingItem();
        Integer maxvisr = (Integer)Reflector.invoke(item.func_77973_b(), "getMaxVis", Integer.class, new Object[0]);
        if (maxvisr == null) {
            return false;
        }
        int maxvis = maxvisr;
        item.field_77990_d = new NBTTagCompound();
        item.field_77990_d.func_74777_a("vis", (short)maxvis);
        player.setHeldItem(item);
        player.alignToTurtle(turtle, Util.OPPOSITE[side]);
        int id = world.func_72798_a(x, y, z);
        if (Block.field_71973_m[id] != null && ThaumcraftApi.decreaseClosestAura((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (int)1, (boolean)false)) {
            boolean ret = item.func_77973_b().onItemUseFirst(item, (EntityPlayer)player, world, x, y, z, side, 0.0f, 0.0f, 0.0f) && ThaumcraftApi.decreaseClosestAura((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (int)1, (boolean)true);
            int dec = maxvis - item.field_77990_d.func_74765_d("vis");
            if (dec > 0) {
                ThaumcraftApi.decreaseClosestAura((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (int)dec, (boolean)true);
            }
            if (player.func_70694_bm() == null) {
                for (TurtleSide tside : Util.TURTLE_SIDES) {
                    if (turtle.getUpgrade(tside) != this) continue;
                    Util.setTurtleUpgrade(turtle, tside, null);
                    break;
                }
            }
            return ret;
        }
        return false;
    }
}

