/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.upgrade;

import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleSide;
import dan200.turtle.api.TurtleUpgradeType;
import dan200.turtle.api.TurtleVerb;
import miscperipherals.api.IUpgradeIcons;
import miscperipherals.peripheral.PeripheralBarrel;
import miscperipherals.safe.ReflectionStore;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class UpgradeBarrel
implements ITurtleUpgrade,
IUpgradeIcons {
    private Icon[] icons = new Icon[15];

    public int getUpgradeID() {
        return 243;
    }

    public String getAdjective() {
        return "Barrel";
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    public ItemStack getCraftingItem() {
        return ReflectionStore.barrel_item == null ? new ItemStack((Block)Block.field_72077_au) : ReflectionStore.barrel_item.func_77946_l();
    }

    public boolean isSecret() {
        return false;
    }

    public Icon getIcon(ITurtleAccess turtle, TurtleSide side) {
        if (turtle == null) {
            return this.icons[0];
        }
        IHostedPeripheral peripheral = turtle.getPeripheral(side);
        if (!(peripheral instanceof PeripheralBarrel)) {
            return this.icons[0];
        }
        PeripheralBarrel barrel = (PeripheralBarrel)peripheral;
        if (barrel.clientAmount == 0) {
            return this.icons[0];
        }
        if (barrel.clientAmount == barrel.maxSize) {
            return this.icons[15];
        }
        return this.icons[1 + (int)Math.ceil((double)barrel.clientAmount / (double)barrel.maxSize) * 14];
    }

    public IHostedPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new PeripheralBarrel(turtle);
    }

    public boolean useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int direction) {
        return false;
    }

    @Override
    public void registerIcons(IconRegister reg) {
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = reg.func_94245_a("MiscPeripherals:barrel" + i);
        }
    }
}

