/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.PacketDispatcher;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.core.LuaManager;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.TickHandler;
import miscperipherals.tile.Tile;
import miscperipherals.util.Util;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Facing;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TileTeleporter
extends Tile
implements IPeripheral {
    public final Stack links = new Stack();
    public final int maxLinks;
    private String error;

    public TileTeleporter() {
        this.maxLinks = 1;
    }

    public TileTeleporter(int maxLinks) {
        this.maxLinks = maxLinks;
    }

    public String getType() {
        return "teleporter";
    }

    public String[] getMethodNames() {
        return new String[]{"teleport", "tp", "getError"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: 
            case 1: {
                int index;
                if (arguments.length > 0 && !(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int n = index = arguments.length > 0 ? (int)Math.floor((Double)arguments[0]) - 1 : 0;
                if (index < 0 || index >= this.maxLinks) {
                    throw new Exception("bad link " + (index + 1) + " (expected 1-" + this.maxLinks + ")");
                }
                Future callback = TickHandler.addTickCallback(this.field_70331_k, new Callable(){

                    public Boolean call() {
                        int zdif;
                        int ydif;
                        int linkToZ;
                        int linkToY;
                        if (index >= TileTeleporter.this.links.size()) {
                            TileTeleporter.this.error = "No such link";
                            return false;
                        }
                        LinkData link = (LinkData)TileTeleporter.this.links.get(index);
                        if (link == null) {
                            TileTeleporter.this.error = "No such link";
                            return false;
                        }
                        TileEntity te = TileTeleporter.this.field_70331_k.func_72796_p(TileTeleporter.this.field_70329_l + Facing.field_71586_b[TileTeleporter.this.getFacing()], TileTeleporter.this.field_70330_m + Facing.field_71587_c[TileTeleporter.this.getFacing()], TileTeleporter.this.field_70327_n + Facing.field_71585_d[TileTeleporter.this.getFacing()]);
                        if (!(te instanceof ITurtleAccess)) {
                            TileTeleporter.this.error = "No turtle in front";
                            return false;
                        }
                        WorldServer destWorld = MinecraftServer.func_71276_C().func_71218_a(link.linkDim);
                        if (destWorld == null) {
                            TileTeleporter.this.error = "Destination world missing";
                            return false;
                        }
                        TileEntity dest = destWorld.func_72796_p(link.link.field_71574_a, link.link.field_71572_b, link.link.field_71573_c);
                        if (!(dest instanceof TileTeleporter)) {
                            TileTeleporter.this.error = "Destination is not a teleporter";
                            return false;
                        }
                        TileTeleporter teleporter = (TileTeleporter)dest;
                        int linkToX = link.link.field_71574_a + Facing.field_71586_b[teleporter.getFacing()];
                        if (!Util.isPassthroughBlock((World)destWorld, linkToX, linkToY = link.link.field_71572_b + Facing.field_71587_c[teleporter.getFacing()], linkToZ = link.link.field_71573_c + Facing.field_71585_d[teleporter.getFacing()])) {
                            TileTeleporter.this.error = "Destination obstructed";
                            return false;
                        }
                        ITurtleAccess turtle = (ITurtleAccess)te;
                        int xdif = Math.abs(TileTeleporter.this.field_70329_l - link.link.field_71574_a);
                        if (!turtle.consumeFuel(Math.abs((int)Math.ceil((double)((xdif + (ydif = Math.abs(TileTeleporter.this.field_70330_m - link.link.field_71572_b)) + (zdif = Math.abs(TileTeleporter.this.field_70327_n - link.link.field_71573_c))) * (Math.abs(TileTeleporter.this.field_70331_k.field_73011_w.field_76574_g - destWorld.field_73011_w.field_76574_g) + 1)) * MiscPeripherals.instance.teleporterPenalty)))) {
                            TileTeleporter.this.error = "Not enough fuel";
                            return false;
                        }
                        boolean result = Util.teleportTurtleTo(turtle, (World)destWorld, linkToX, linkToY, linkToZ);
                        if (result) {
                            int flag = TileTeleporter.this.field_70331_k.field_73011_w.field_76574_g != destWorld.field_73011_w.field_76574_g ? 1 : 0;
                            ByteArrayDataOutput os = ByteStreams.newDataOutput();
                            os.writeInt(TileTeleporter.this.field_70329_l);
                            os.writeInt(TileTeleporter.this.field_70330_m);
                            os.writeInt(TileTeleporter.this.field_70327_n);
                            os.writeByte(flag);
                            PacketDispatcher.sendPacketToAllAround((double)((double)TileTeleporter.this.field_70329_l + 0.5), (double)((double)TileTeleporter.this.field_70330_m + 0.5), (double)((double)TileTeleporter.this.field_70327_n + 0.5), (double)64.0, (int)TileTeleporter.this.field_70331_k.field_73011_w.field_76574_g, (Packet)PacketDispatcher.getTinyPacket((Object)MiscPeripherals.instance, (short)4, (byte[])os.toByteArray()));
                            TileTeleporter.this.onTeleport((byte)flag);
                            os = ByteStreams.newDataOutput();
                            os.writeInt(teleporter.field_70329_l);
                            os.writeInt(teleporter.field_70330_m);
                            os.writeInt(teleporter.field_70327_n);
                            os.writeByte(flag);
                            PacketDispatcher.sendPacketToAllAround((double)((double)teleporter.field_70329_l + 0.5), (double)((double)teleporter.field_70330_m + 0.5), (double)((double)teleporter.field_70327_n + 0.5), (double)64.0, (int)destWorld.field_73011_w.field_76574_g, (Packet)PacketDispatcher.getTinyPacket((Object)MiscPeripherals.instance, (short)4, (byte[])os.toByteArray()));
                            teleporter.onTeleport((byte)flag);
                        }
                        return result;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 2: {
                return new Object[]{this.error};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    @Override
    public void func_70307_a(NBTTagCompound compound) {
        super.func_70307_a(compound);
        NBTTagList links = compound.func_74761_m("links");
        for (int i = 0; i < links.func_74745_c(); ++i) {
            NBTTagCompound link = (NBTTagCompound)links.func_74743_b(i);
            if (!link.func_74764_b("linkX") || !link.func_74764_b("linkY") || !link.func_74764_b("linkZ") || !link.func_74764_b("linkDim")) continue;
            this.links.add(new LinkData(compound.func_74762_e("linkDim"), new ChunkCoordinates(compound.func_74762_e("linkX"), compound.func_74762_e("linkY"), compound.func_74762_e("linkZ"))));
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound compound) {
        super.func_70310_b(compound);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.links.size(); ++i) {
            LinkData link = (LinkData)this.links.get(i);
            if (link == null) continue;
            NBTTagCompound lcompound = new NBTTagCompound();
            lcompound.func_74768_a("linkX", link.link.field_71574_a);
            lcompound.func_74768_a("linkY", link.link.field_71572_b);
            lcompound.func_74768_a("linkZ", link.link.field_71573_c);
            lcompound.func_74768_a("linkDim", link.linkDim);
            list.func_74742_a((NBTBase)lcompound);
        }
        compound.func_74782_a("links", (NBTBase)list);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack held = player.func_71045_bC();
        if (held != null && held.field_77993_c == Item.field_77742_bb.field_77779_bT) {
            if (held.field_77990_d != null && held.field_77990_d.func_74764_b("miscperipheralsLinkX") && held.field_77990_d.func_74764_b("miscperipheralsLinkY") && held.field_77990_d.func_74764_b("miscperipheralsLinkZ") && held.field_77990_d.func_74764_b("miscperipheralsLinkDim")) {
                ChunkCoordinates link = new ChunkCoordinates(held.field_77990_d.func_74762_e("miscperipheralsLinkX"), held.field_77990_d.func_74762_e("miscperipheralsLinkY"), held.field_77990_d.func_74762_e("miscperipheralsLinkZ"));
                int linkDim = held.field_77990_d.func_74762_e("miscperipheralsLinkDim");
                WorldServer srcWorld = MinecraftServer.func_71276_C().func_71218_a(linkDim);
                if (srcWorld == null) {
                    player.func_70006_a("Link failed: World is missing");
                } else {
                    TileEntity te = srcWorld.func_72796_p(link.field_71574_a, link.field_71572_b, link.field_71573_c);
                    if (!(te instanceof TileTeleporter)) {
                        player.func_70006_a("Link failed: Teleporter no longer exists");
                    } else {
                        TileTeleporter src = (TileTeleporter)te;
                        if (link.field_71574_a == this.field_70329_l && link.field_71572_b == this.field_70330_m && link.field_71573_c == this.field_70327_n) {
                            player.func_70006_a("Link canceled");
                        } else {
                            boolean unlinked = false;
                            for (int i = 0; i < src.links.size(); ++i) {
                                LinkData rlink = (LinkData)src.links.get(i);
                                System.out.println("comparing: " + rlink.link.field_71574_a + " " + this.field_70329_l + " " + rlink.link.field_71572_b + " " + this.field_70330_m + " " + rlink.link.field_71573_c + " " + this.field_70327_n);
                                if (rlink.link.field_71574_a != this.field_70329_l || rlink.link.field_71572_b != this.field_70330_m || rlink.link.field_71573_c != this.field_70327_n || rlink.linkDim != this.field_70331_k.field_73011_w.field_76574_g) continue;
                                player.func_70006_a("Unlinked teleporter at " + rlink.linkDim + ":(" + rlink.link.field_71574_a + "," + rlink.link.field_71572_b + "," + rlink.link.field_71573_c + ") (link " + (i + 1) + ") from this teleporter");
                                src.links.remove(i);
                                unlinked = true;
                                break;
                            }
                            if (!unlinked) {
                                src.addLink(this.field_70331_k.field_73011_w.field_76574_g, new ChunkCoordinates(this.field_70329_l, this.field_70330_m, this.field_70327_n));
                                player.func_70006_a("Linked teleporter at " + linkDim + ":(" + link.field_71574_a + "," + link.field_71572_b + "," + link.field_71573_c + ") (link " + src.links.size() + ") to this teleporter");
                            }
                        }
                    }
                }
                held.field_77990_d.func_82580_o("miscperipheralsLinkX");
                held.field_77990_d.func_82580_o("miscperipheralsLinkY");
                held.field_77990_d.func_82580_o("miscperipheralsLinkZ");
                held.field_77990_d.func_82580_o("miscperipheralsLinkDim");
                if (held.field_77990_d.func_74764_b("display")) {
                    NBTTagCompound display = held.field_77990_d.func_74775_l("display");
                    display.func_82580_o("Lore");
                    if (display.func_74758_c().isEmpty()) {
                        held.field_77990_d.func_82580_o("display");
                    } else {
                        held.field_77990_d.func_74782_a("display", (NBTBase)display);
                    }
                }
                return true;
            }
            if (held.field_77990_d == null) {
                held.field_77990_d = new NBTTagCompound();
            }
            held.field_77990_d.func_74768_a("miscperipheralsLinkX", this.field_70329_l);
            held.field_77990_d.func_74768_a("miscperipheralsLinkY", this.field_70330_m);
            held.field_77990_d.func_74768_a("miscperipheralsLinkZ", this.field_70327_n);
            held.field_77990_d.func_74768_a("miscperipheralsLinkDim", this.field_70331_k.field_73011_w.field_76574_g);
            NBTTagCompound display = new NBTTagCompound();
            NBTTagList lore = new NBTTagList();
            lore.func_74742_a((NBTBase)new NBTTagString("", "Turtle Teleporter Link"));
            lore.func_74742_a((NBTBase)new NBTTagString("", this.field_70331_k.field_73011_w.field_76574_g + ":(" + this.field_70329_l + "," + this.field_70330_m + "," + this.field_70327_n + ")"));
            display.func_74782_a("Lore", (NBTBase)lore);
            held.field_77990_d.func_74782_a("display", (NBTBase)display);
            player.func_70006_a("Link started");
            return true;
        }
        return false;
    }

    public void onTeleport(byte flag) {
        if (!MiscPeripherals.proxy.isServer()) {
            short facing = this.getFacing();
            for (int j = 0; j < 32; ++j) {
                this.field_70331_k.func_72869_a("portal", (double)this.field_70329_l + 0.5 + 1.0 * (double)Facing.field_71586_b[facing], (double)this.field_70330_m + 1.0 * (double)Facing.field_71587_c[facing] + this.field_70331_k.field_73012_v.nextDouble() * 2.0, (double)this.field_70327_n + 0.5 + 1.0 * (double)Facing.field_71585_d[this.getFacing()], this.field_70331_k.field_73012_v.nextGaussian(), 0.0, this.field_70331_k.field_73012_v.nextGaussian());
            }
        } else {
            String sound = "mob.endermen.portal";
            if (Loader.isModLoaded((String)"Mystcraft")) {
                sound = flag == 1 ? "myst.sound.link-portal" : "myst.sound.link-intra";
            }
            this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, sound, 1.0f, 1.0f);
        }
    }

    public int addLink(int linkDim, ChunkCoordinates link) {
        this.links.add(new LinkData(linkDim, link));
        while (this.links.size() > this.maxLinks) {
            this.links.pop();
        }
        return this.links.size();
    }

    protected static class LinkData {
        public final int linkDim;
        public final ChunkCoordinates link;

        public LinkData(int linkDim, ChunkCoordinates link) {
            this.linkDim = linkDim;
            this.link = link;
        }
    }
}

