/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import java.util.HashMap;
import miscperipherals.core.LuaManager;
import miscperipherals.safe.Reflector;
import miscperipherals.tile.TileInventory;
import miscperipherals.util.Util;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.MapData;

public class TileScanner
extends TileInventory
implements IPeripheral {
    public TileScanner() {
        super(1);
    }

    @Override
    public int getGuiId() {
        return 2;
    }

    @Override
    public String func_70303_b() {
        return "Scanner";
    }

    public String getType() {
        return "scanner";
    }

    public String[] getMethodNames() {
        return new String[]{"scanPrintout", "scanMap"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                ItemStack stack = this.func_70301_a(0);
                if (stack == null || !stack.func_77973_b().getClass().getName().equals("dan200.computer.shared.ItemPrintout")) {
                    return new Object[]{null, null};
                }
                String title = (String)Reflector.invoke("dan200.computer.shared.ItemPrintout", "getTitle", String.class, stack);
                String[] text = (String[])Reflector.invoke("dan200.computer.shared.ItemPrintout", "getText", String[].class, stack);
                if (title == null || text == null) {
                    return new Object[]{null, null};
                }
                this.setActive(true);
                Thread.sleep(100 * text.length);
                this.setActive(false);
                HashMap<Integer, String> textMap = new HashMap<Integer, String>();
                for (int i = 0; i < text.length; ++i) {
                    textMap.put(i, text[i]);
                }
                return new Object[]{title, textMap};
            }
            case 1: {
                if (arguments.length != 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int line = ((Double)arguments[0]).intValue();
                ItemStack stack = this.func_70301_a(0);
                if (stack == null || !(stack.func_77973_b() instanceof ItemMap)) {
                    return new Object[]{-1, null};
                }
                MapData data = Item.field_77744_bd.func_77873_a(stack, this.field_70331_k);
                int wh = (int)Math.sqrt(data.field_76198_e.length);
                if (line < 1 || line > wh) {
                    throw new Exception("invalid line (expected 1-" + wh + ")");
                }
                this.setActive(true);
                Thread.sleep(wh * 20);
                this.setActive(false);
                HashMap<Integer, Integer> colors = new HashMap<Integer, Integer>();
                for (int i = --line * wh; i < line * wh + wh; ++i) {
                    colors.put(i, Util.MAP_COLORS[data.field_76198_e[i]].getRGB());
                }
                return new Object[]{stack.func_77960_j(), colors};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }
}

