/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.Util;
import appeng.api.exceptions.AppEngTileMissingException;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.core.TickHandler;
import miscperipherals.tile.TileInteractiveSorter;
import miscperipherals.tile.TileMEBase;
import net.minecraft.item.ItemStack;

public class TileMEBridge
extends TileMEBase
implements IPeripheral {
    public static float ITEM_ENERGY_FACTOR = 21.333334f;

    public String getType() {
        return "meBridge";
    }

    public String[] getMethodNames() {
        return new String[]{"listAll", "listItems", "listCraft", "retrieve", "craft"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (this.grid == null) {
                    return new Object[0];
                }
                return new Object[]{this.getAvailableItemMap(this.grid.getFullCellArray().getAvailableItems())};
            }
            case 1: {
                if (this.grid == null) {
                    return new Object[0];
                }
                return new Object[]{this.getAvailableItemMap(this.grid.getCellArray().getAvailableItems())};
            }
            case 2: {
                if (this.grid == null) {
                    return new Object[0];
                }
                return new Object[]{this.getAvailableItemMap(this.grid.getCraftableArray().getAvailableItems())};
            }
            case 3: {
                if (arguments.length < 3) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                if (!(arguments[2] instanceof Double)) {
                    throw new Exception("bad argument #3 (expected number)");
                }
                final int uuid = (int)Math.floor((Double)arguments[0]);
                final int amount = Math.abs((int)Math.floor((Double)arguments[1]));
                final int outDir = (int)Math.floor((Double)arguments[2]);
                if (outDir < 0 || outDir > 5) {
                    throw new Exception("bad direction " + outDir + " (expected 0-5)");
                }
                if (this.grid == null) {
                    return new Object[0];
                }
                Future callback = TickHandler.addTickCallback(this.field_70331_k, new Callable(){

                    public Long call() {
                        if (!TileMEBridge.this.grid.useMEEnergy((float)amount / ITEM_ENERGY_FACTOR, "ME Bridge Extraction")) {
                            return 0L;
                        }
                        ItemStack ostack = miscperipherals.util.Util.getUUID(uuid, amount);
                        if (ostack.func_77973_b() == null) {
                            return 0L;
                        }
                        long ret = 0L;
                        while (ostack.field_77994_a > 0) {
                            ItemStack reqStack = ostack.func_77946_l();
                            reqStack.field_77994_a = Math.min(ostack.field_77994_a, ostack.func_77976_d());
                            IAEItemStack request = Util.createItemStack((ItemStack)reqStack);
                            IAEItemStack returned = TileMEBridge.this.grid.getCellArray().extractItems(request);
                            if (returned == null) break;
                            ItemStack output = returned.getItemStack();
                            int base = output.field_77994_a;
                            TileInteractiveSorter.outputItem(TileMEBridge.this, output, outDir);
                            if (output.field_77994_a > 0) {
                                IAEItemStack remainder = Util.createItemStack((ItemStack)output);
                                TileMEBridge.this.grid.getCellArray().addItems(remainder);
                            }
                            int total = base - output.field_77994_a;
                            ostack.field_77994_a -= total;
                            ret += (long)total;
                        }
                        return ret;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 4: {
                if (arguments.length < 2) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                final int uuid = (int)Math.floor((Double)arguments[0]);
                final int amount = Math.abs((int)Math.floor((Double)arguments[1]));
                if (this.grid == null) {
                    return new Object[0];
                }
                Future callback = TickHandler.addTickCallback(this.field_70331_k, new Callable(){

                    public Object call() {
                        try {
                            TileMEBridge.this.grid.craftingRequest(miscperipherals.util.Util.getUUID(uuid, amount));
                        }
                        catch (AppEngTileMissingException e) {
                            throw new RuntimeException("something went wrong on AE's side: " + e.getMessage());
                        }
                        return null;
                    }
                });
                callback.get();
                return new Object[0];
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    private Map getAvailableItemMap(IItemList list) {
        HashMap<Integer, Double> items = new HashMap<Integer, Double>();
        for (IAEItemStack stack : this.grid.getCellArray().getAvailableItems()) {
            items.put(miscperipherals.util.Util.getUUID(stack.getItemStack()), Double.valueOf(stack.getStackSize()));
        }
        return items;
    }
}

