/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import cpw.mods.fml.common.FMLCommonHandler;
import dan200.turtle.api.ITurtleAccess;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.List;
import miscperipherals.asm.ImplementIfLoaded;
import miscperipherals.asm.OwnerInterface;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.tile.TileInventory;
import miscperipherals.util.Util;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraftforge.common.ForgeDirection;

@ImplementIfLoaded(value={"IC2", "ic2.", "BuildCraft|Core", "buildcraft."})
public class TileChargeStation
extends TileInventory
implements IEnergySink,
IPowerReceptor {
    public static final List PLUGINS = new ArrayList(3);
    public double energy = 0.0;
    public int limit = 0;
    public int[] sides = this.getSides();
    public final int tier;
    public boolean addedToEnergyNet = false;
    public boolean addedToUE = false;
    public Object bcProvider;

    public TileChargeStation() {
        this(1);
    }

    public TileChargeStation(int tier) {
        super(1);
        this.tier = tier;
        for (ChargeStationPlugin plugin : PLUGINS) {
            plugin.initialize(this);
        }
    }

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public void func_70316_g() {
        super.func_70316_g();
        for (ChargeStationPlugin plugin : PLUGINS) {
            plugin.update(this);
        }
        if (!this.isDisabled() && this.energy > 1.0) {
            ArrayList<ITurtleAccess> turtles = new ArrayList<ITurtleAccess>(this.sides.length);
            for (int i = 0; i < this.sides.length; ++i) {
                TileEntity te;
                int x = this.field_70329_l + Facing.field_71586_b[this.sides[i]];
                int y = this.field_70330_m + Facing.field_71587_c[this.sides[i]];
                int z = this.field_70327_n + Facing.field_71585_d[this.sides[i]];
                if (!this.field_70331_k.func_72899_e(x, y, z) || !((te = this.field_70331_k.func_72796_p(x, y, z)) instanceof ITurtleAccess)) continue;
                turtles.add((ITurtleAccess)te);
            }
            int rate = (int)Math.floor((float)this.sides.length / (float)turtles.size());
            for (ITurtleAccess turtle : turtles) {
                this.energy -= (double)Util.addFuel(turtle, rate);
            }
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        try {
            this.energy = tag.func_74769_h("energy");
        }
        catch (Throwable e) {
            this.energy = tag.func_74762_e("energy");
        }
        this.limit = tag.func_74762_e("limit");
        for (ChargeStationPlugin plugin : PLUGINS) {
            plugin.readFromNBT(this, tag);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74780_a("energy", this.energy);
        tag.func_74768_a("limit", this.limit);
        for (ChargeStationPlugin plugin : PLUGINS) {
            plugin.writeToNBT(this, tag);
        }
    }

    @Override
    public String func_70303_b() {
        return "Charge Station";
    }

    @Override
    public int getGuiId() {
        return 0;
    }

    @Override
    public void setFacing(int facing) {
        super.setFacing(facing);
        this.sides = this.getSides();
    }

    public int getMaxCharge() {
        return 50 * (int)Math.pow(10.0, this.tier);
    }

    public int[] getSides() {
        return new int[]{this.getFacing()};
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack item) {
        return true;
    }

    @Override
    public void onUnloaded() {
        for (ChargeStationPlugin plugin : PLUGINS) {
            plugin.unload(this);
        }
        super.onUnloaded();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        for (ChargeStationPlugin plugin : PLUGINS) {
            if (!plugin.onBlockActivated(this, player, side, hitX, hitY, hitZ)) continue;
            return true;
        }
        return super.onBlockActivated(player, side, hitX, hitY, hitZ);
    }

    @Override
    public int getComparator(int side) {
        return (int)Math.ceil(this.energy / (double)this.getMaxCharge() * 15.0);
    }

    @OwnerInterface(value="ic2.api.energy.tile.IEnergySink")
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    @OwnerInterface(value="ic2.api.energy.tile.IEnergySink")
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @OwnerInterface(value="ic2.api.energy.tile.IEnergySink")
    public int demandsEnergy() {
        return (int)Math.floor(((double)this.getMaxCharge() - this.energy) * (double)MiscPeripherals.instance.fuelEU);
    }

    @OwnerInterface(value="ic2.api.energy.tile.IEnergySink")
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.getMaxSafeInput()) {
            for (ChargeStationPlugin plugin : PLUGINS) {
                plugin.unload(this);
            }
            this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0, 2);
            this.field_70331_k.func_72876_a(null, (double)((float)this.field_70329_l + 0.5f), (double)((float)this.field_70330_m + 0.5f), (double)((float)this.field_70327_n + 0.5f), 2.0f, false);
            return amount;
        }
        double toAdd = Math.min((double)amount / (double)MiscPeripherals.instance.fuelEU, (double)this.getMaxCharge() - this.energy);
        this.energy += toAdd;
        return (int)Math.floor((double)amount - toAdd * (double)MiscPeripherals.instance.fuelEU);
    }

    @OwnerInterface(value="ic2.api.energy.tile.IEnergySink")
    public int getMaxSafeInput() {
        return this.tier == 1 ? 32 : (this.tier == 2 ? 128 : (this.tier == 3 ? 512 : (this.tier == 4 ? 2048 : Integer.MAX_VALUE)));
    }

    @OwnerInterface(value="buildcraft.api.power.IPowerReceptor")
    public void setPowerProvider(IPowerProvider provider) {
        this.bcProvider = provider;
    }

    @OwnerInterface(value="buildcraft.api.power.IPowerReceptor")
    public IPowerProvider getPowerProvider() {
        return (IPowerProvider)this.bcProvider;
    }

    @OwnerInterface(value="buildcraft.api.power.IPowerReceptor")
    public void doWork() {
        float sink = ((IPowerProvider)this.bcProvider).useEnergy(0.0f, (float)(((double)this.getMaxCharge() - this.energy) * (double)MiscPeripherals.instance.fuelMJ), true);
        this.energy += (double)sink / (double)MiscPeripherals.instance.fuelMJ;
    }

    @OwnerInterface(value="buildcraft.api.power.IPowerReceptor")
    public int powerRequest(ForgeDirection direction) {
        return MiscPeripherals.instance.fuelMJ * this.getSides().length;
    }

    public boolean isDisabled() {
        for (ChargeStationPlugin plugin : PLUGINS) {
            if (!plugin.isDisabled(this)) continue;
            return true;
        }
        return false;
    }

    public static interface ChargeStationPlugin {
        public boolean isBattery(TileChargeStation var1, ItemStack var2);

        public void update(TileChargeStation var1);

        public void unload(TileChargeStation var1);

        public boolean onBlockActivated(TileChargeStation var1, EntityPlayer var2, int var3, float var4, float var5, float var6);

        public void readFromNBT(TileChargeStation var1, NBTTagCompound var2);

        public void writeToNBT(TileChargeStation var1, NBTTagCompound var2);

        public void initialize(TileChargeStation var1);

        public boolean isDisabled(TileChargeStation var1);
    }
}

