/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.HashMap;
import java.util.Map;
import miscperipherals.core.LuaManager;
import miscperipherals.tile.TileInventory;
import net.minecraft.item.ItemStack;

public abstract class TileAnalyzer
extends TileInventory
implements IPeripheral {
    public TileAnalyzer() {
        super(1);
    }

    @Override
    public int getGuiId() {
        return 2;
    }

    @Override
    public abstract String func_70303_b();

    public abstract String getType();

    public String[] getMethodNames() {
        return new String[]{"analyze", "isMember", "isBee", "isTree"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                ISpeciesRoot root = this.getRoot();
                ItemStack stack = this.func_70301_a(0);
                if (stack == null || !root.isMember(stack)) {
                    return new Object[]{false};
                }
                IIndividual individual = root.getMember(stack);
                if (!individual.isAnalyzed()) {
                    return new Object[]{null};
                }
                HashMap ret = new HashMap();
                this.addGenome(stack, individual.getGenome(), ret);
                return new Object[]{ret};
            }
            case 1: 
            case 2: 
            case 3: {
                ItemStack stack = this.func_70301_a(0);
                if (stack == null || !this.getRoot().isMember(stack)) {
                    return new Object[]{false};
                }
                return new Object[]{true};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    protected ISpeciesRoot getRoot() {
        return AlleleManager.alleleRegistry.getSpeciesRoot(this.getRootType());
    }

    protected abstract String getRootType();

    protected abstract void addGenome(ItemStack var1, IGenome var2, Map var3);
}

