/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.speech;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.speech.ISpeechProvider;
import miscperipherals.speech.PriorityComparator;
import miscperipherals.speech.SpeechProviderEspeak;
import miscperipherals.speech.SpeechProviderFestival;
import miscperipherals.speech.SpeechProviderGoogle;
import miscperipherals.speech.SpeechProviderOSX;
import miscperipherals.speech.SpeechProviderPico2wave;
import miscperipherals.speech.SpeechProviderWindows;
import miscperipherals.speech.StreamGobbler;
import miscperipherals.speech.ThreadSpeechProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumOS;

@SideOnly(value=Side.CLIENT)
public class SpeechManager {
    static final List providers = new ArrayList();
    private static final Comparator comparator = new PriorityComparator();
    static ISpeechProvider preferred;
    private static Throwable jacobFail;
    private static Throwable addpathFail;

    public static void init() {
        if (SpeechManager.isWindows()) {
            try {
                for (String file : new String[]{"jacob-1.17-M2-x86.dll", "jacob-1.17-M2-x64.dll"}) {
                    int read;
                    File f = new File(".", file);
                    InputStream is = SpeechManager.class.getResourceAsStream("/com/jacob/" + file);
                    FileOutputStream os = new FileOutputStream(f);
                    byte[] buffer = new byte[8192];
                    while ((read = is.read(buffer)) != -1) {
                        os.write(buffer, 0, read);
                        os.flush();
                    }
                    is.close();
                    os.close();
                }
            }
            catch (Throwable e) {
                MiscPeripherals.log.warning("Failed to extract JACOB!");
                e.printStackTrace();
                jacobFail = e;
            }
        }
        if (SpeechManager.isWindows()) {
            try {
                SpeechManager.addLibraryPath(".");
            }
            catch (Throwable e) {
                addpathFail = e;
            }
            try {
                SpeechProviderWindows sp = new SpeechProviderWindows();
                providers.add(sp);
            }
            catch (UnsatisfiedLinkError e) {
                MiscPeripherals.log.warning("Unsatisfied link when loading JACOB! Debug information follows");
                MiscPeripherals.log.warning("");
                File f = new File(".", "jacob-1.17-M2-x86.dll");
                MiscPeripherals.log.warning("JACOB x86 exists: " + f.exists() + " - size: " + f.length());
                f = new File(".", "jacob-1.17-M2-x64.dll");
                MiscPeripherals.log.warning("JACOB x64 exists: " + f.exists() + " - size: " + f.length());
                MiscPeripherals.log.warning("And in MC dir: x86:" + new File(Minecraft.func_71380_b(), "jacob-1.17-M2-x86.dll").exists() + " x64:" + new File(Minecraft.func_71380_b(), "jacob-1.17-M2-x64.dll").exists());
                MiscPeripherals.log.warning("");
                MiscPeripherals.log.warning(". is " + new File(".").getAbsolutePath());
                MiscPeripherals.log.warning("minecraftDir is " + Minecraft.func_71380_b().getAbsolutePath());
                MiscPeripherals.log.warning("");
                MiscPeripherals.log.warning("Extraction failed: " + (jacobFail != null));
                if (jacobFail != null) {
                    jacobFail.printStackTrace();
                }
                MiscPeripherals.log.warning("");
                MiscPeripherals.log.warning("Adding library path failed: " + (addpathFail != null));
                if (addpathFail != null) {
                    addpathFail.printStackTrace();
                }
                MiscPeripherals.log.warning("");
                MiscPeripherals.log.warning("Unsatisfied link:");
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (SpeechManager.isMac()) {
            providers.add(new SpeechProviderOSX());
        }
        if (SpeechProviderEspeak.getEspeakExecutable() != null) {
            providers.add(new SpeechProviderEspeak());
        }
        if (SpeechProviderFestival.getFestivalExecutable() != null) {
            providers.add(new SpeechProviderFestival());
        }
        if (SpeechProviderPico2wave.getPico2waveExecutable() != null) {
            providers.add(new SpeechProviderPico2wave());
        }
        if (SpeechProviderGoogle.getEncoder() != null) {
            providers.add(new SpeechProviderGoogle());
        }
        Collections.sort(providers, comparator);
        if (!MiscPeripherals.instance.speechProvider.isEmpty()) {
            for (ISpeechProvider provider : providers) {
                if (!provider.getName().equalsIgnoreCase(MiscPeripherals.instance.speechProvider)) continue;
                preferred = provider;
                return;
            }
        }
    }

    public static void registerProvider(ISpeechProvider provider) {
        providers.add(provider);
        Collections.sort(providers, comparator);
    }

    public static void speak(String text, double speed, double x, double y, double z) {
        new ThreadSpeechProvider(text, speed, x, y, z).start();
    }

    public static File makeTempFile(String suffix) throws IOException {
        return File.createTempFile("miscperipherals_speech_temp", suffix, new File(Minecraft.func_71380_b(), "miscperipherals"));
    }

    public static boolean runProcess(String ... cmdline) throws IOException, InterruptedException {
        return SpeechManager.runProcessStdin(null, cmdline);
    }

    public static boolean runProcessStdin(String stdin, String ... cmdline) throws IOException, InterruptedException {
        File f = File.createTempFile("miscperipherals_speech_log", ".txt", new File(Minecraft.func_71380_b(), "miscperipherals"));
        FileOutputStream os = new FileOutputStream(f);
        Process process = new ProcessBuilder(cmdline).start();
        new StreamGobbler(process.getInputStream(), os);
        new StreamGobbler(process.getErrorStream(), os);
        if (stdin != null) {
            PrintWriter pw = new PrintWriter(process.getOutputStream(), true);
            pw.println(stdin);
            pw.close();
        }
        int exitCode = process.waitFor();
        os.flush();
        ((OutputStream)os).close();
        if (exitCode != 0) {
            MiscPeripherals.log.warning("Speech process '" + cmdline[0] + "' returned exit code " + exitCode + " - log saved to " + f.getName());
            MiscPeripherals.log.warning("Full command line: " + Arrays.toString(cmdline));
            return false;
        }
        if (!f.delete()) {
            f.deleteOnExit();
        }
        return true;
    }

    public static void addLibraryPath(String pathToAdd) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        String[] paths;
        Field usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
        usrPathsField.setAccessible(true);
        for (String path : paths = (String[])usrPathsField.get(null)) {
            if (!path.equals(pathToAdd)) continue;
            return;
        }
        String[] newPaths = Arrays.copyOf(paths, paths.length + 1);
        newPaths[newPaths.length - 1] = pathToAdd;
        usrPathsField.set(null, newPaths);
    }

    public static boolean isWindows() {
        return Minecraft.func_71376_c() == EnumOS.WINDOWS;
    }

    public static boolean isMac() {
        return Minecraft.func_71376_c() == EnumOS.MACOS;
    }

    static {
        jacobFail = null;
        addpathFail = null;
    }
}

