/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.api.IXPSource;
import miscperipherals.core.LuaManager;
import miscperipherals.core.TickHandler;
import miscperipherals.util.RandomExt;
import miscperipherals.util.Util;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class PeripheralXP
implements IHostedPeripheral {
    private static final int TICK_RATE = 20;
    private static final double COLLECT_RANGE = 2.0;
    private static final int MAX_LEVEL = 30;
    private final ITurtleAccess turtle;
    private final RandomExt random = new RandomExt();
    private int experience = 0;
    private int experienceRemainder = 0;
    private int experienceLevel = 0;
    private boolean autoCollect = false;
    private int ticker = this.random.nextInt(20);

    public PeripheralXP(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "xp";
    }

    public String[] getMethodNames() {
        return new String[]{"add", "getXP", "getLevels", "collect", "setAutoCollect", "enchant", "get", "getUp", "getDown", "fixBook"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                Entity ent;
                ItemStack slot = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                int amount = Integer.MAX_VALUE;
                if (arguments.length > 0) {
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    amount = (int)Math.floor((Double)arguments[0]);
                }
                if (slot == null) {
                    return new Object[]{0};
                }
                amount = Math.min(amount, slot.field_77994_a);
                int recharge = 0;
                if (slot.field_77993_c == Item.field_77809_bD.field_77779_bT) {
                    recharge = 3 + this.random.nextInt(5) + this.random.nextInt(5);
                } else if (slot.field_77993_c == Item.field_77815_bC.field_77779_bT && (ent = EntityList.func_75616_a((int)slot.func_77960_j(), (World)this.turtle.getWorld())) instanceof EntityLiving) {
                    recharge = ((EntityLiving)ent).field_70728_aV;
                }
                this.addExperience(recharge *= amount);
                if (recharge > 0) {
                    slot.field_77994_a -= amount;
                    if (slot.field_77994_a <= 0) {
                        slot = null;
                    }
                    this.turtle.setSlotContents(this.turtle.getSelectedSlot(), slot);
                }
                return new Object[]{recharge};
            }
            case 1: {
                return new Object[]{this.experience};
            }
            case 2: {
                return new Object[]{this.experienceLevel};
            }
            case 3: {
                int collected = this.collect();
                this.addExperience(collected);
                return new Object[]{collected};
            }
            case 4: {
                boolean ac;
                boolean bl = ac = !this.autoCollect;
                if (arguments.length > 0) {
                    if (!(arguments[0] instanceof Boolean)) {
                        throw new Exception("bad argument #1 (expected boolean)");
                    }
                    ac = (Boolean)arguments[0];
                }
                this.autoCollect = ac;
                return new Object[]{this.autoCollect};
            }
            case 5: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int levels = (int)Math.floor((Double)arguments[0]);
                if (levels < 1 || levels > 30) {
                    throw new Exception("invalid level count " + levels + " (expected 1-" + 30 + ")");
                }
                ItemStack slot = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                if (!slot.func_77956_u()) {
                    return new Object[]{false};
                }
                if (this.experienceLevel < levels) {
                    return new Object[]{false};
                }
                List enchants = EnchantmentHelper.func_77513_b((Random)this.random, (ItemStack)slot, (int)levels);
                if (enchants == null || enchants.isEmpty()) {
                    return new Object[]{false};
                }
                ItemStack enchanted = slot.func_77946_l();
                if (PeripheralXP.isBook(enchanted)) {
                    enchanted = new ItemStack((Item)Item.field_92105_bW);
                    enchanted.field_77990_d = new NBTTagCompound("tag");
                    NBTTagList storedEnchantments = new NBTTagList("StoredEnchantments");
                    NBTTagCompound enchantment = new NBTTagCompound();
                    EnchantmentData data = (EnchantmentData)enchants.get(0);
                    enchantment.func_74777_a("id", (short)data.field_76302_b.field_77352_x);
                    enchantment.func_74777_a("lvl", (short)data.field_76303_c);
                    storedEnchantments.func_74742_a((NBTBase)enchantment);
                    enchanted.field_77990_d.func_74782_a("StoredEnchantments", (NBTBase)storedEnchantments);
                } else {
                    for (EnchantmentData data : enchants) {
                        enchanted.func_77966_a(data.field_76302_b, data.field_76303_c);
                    }
                }
                this.addLevels(-levels, true);
                this.turtle.setSlotContents(this.turtle.getSelectedSlot(), enchanted);
                return new Object[]{true};
            }
            case 6: 
            case 7: 
            case 8: {
                final int m = method;
                Future callback = TickHandler.addTickCallback(this.turtle.getWorld(), new Callable(){

                    public Integer call() {
                        int toAdd = 0;
                        MovingObjectPosition mop = Util.rayTraceBlock(PeripheralXP.this.turtle, m == 6 ? PeripheralXP.this.turtle.getFacingDir() : (m == 7 ? 1 : 0));
                        for (IXPSource xpsource : IXPSource.handlers) {
                            try {
                                toAdd += xpsource.get(PeripheralXP.this.turtle, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, mop.field_72310_e);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                        PeripheralXP.this.addExperience(toAdd);
                        return toAdd;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 9: {
                NBTTagList list;
                ItemStack stack = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                if (stack != null && stack.field_77993_c == Item.field_92105_bW.field_77779_bT && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("StoredEnchantments") && (list = stack.field_77990_d.func_74761_m("StoredEnchantments")).func_74745_c() > 1) {
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        ItemStack book = new ItemStack((Item)Item.field_92105_bW);
                        book.field_77990_d = new NBTTagCompound("tag");
                        NBTTagList storedEnchantments = new NBTTagList("StoredEnchantments");
                        storedEnchantments.func_74742_a(list.func_74743_b(i).func_74737_b());
                        book.field_77990_d.func_74782_a("StoredEnchantments", (NBTBase)storedEnchantments);
                        Util.storeOrDrop(this.turtle, book);
                    }
                    this.turtle.setSlotContents(this.turtle.getSelectedSlot(), null);
                }
                throw new Exception("This is a debug function used by me to fix glitched enchanted books. Those were only possible to obtain in a internal ForgeCraft testing version.");
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
        if (this.autoCollect && ++this.ticker >= 20) {
            this.ticker = 0;
            this.addExperience(this.collect());
        }
    }

    private int collect() {
        int ret = 0;
        Vec3 pos = this.turtle.getPosition();
        for (EntityXPOrb orb : this.turtle.getWorld().func_72872_a(EntityXPOrb.class, AxisAlignedBB.func_72332_a().func_72299_a(pos.field_72450_a - 2.0, pos.field_72448_b - 2.0, pos.field_72449_c - 2.0, pos.field_72450_a + 1.0 + 2.0, pos.field_72448_b + 1.0 + 2.0, pos.field_72449_c + 1.0 + 2.0))) {
            ret += orb.func_70526_d();
            orb.func_70106_y();
        }
        return ret;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.experience = nbttagcompound.func_74762_e("experience");
        this.experienceRemainder = nbttagcompound.func_74762_e("experienceRemainder");
        this.experienceLevel = nbttagcompound.func_74762_e("experienceLevel");
        this.random.setSeed(nbttagcompound.func_74763_f("rndSeed"));
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("experience", this.experience);
        nbttagcompound.func_74768_a("experienceRemainder", this.experienceRemainder);
        nbttagcompound.func_74768_a("experienceLevel", this.experienceLevel);
        nbttagcompound.func_74772_a("rndSeed", this.random.getSeed());
    }

    public void addExperience(int par1) {
        int var2 = Integer.MAX_VALUE - this.experience;
        if (par1 > var2) {
            par1 = var2;
        }
        this.experienceRemainder += par1;
        this.experience += par1;
        while (this.experienceRemainder < 0 || this.experienceRemainder >= this.thisLevelXP()) {
            this.addLevels(this.experienceRemainder < 0 ? -1 : 1, false);
            this.experienceRemainder -= this.thisLevelXP() * (this.experienceRemainder < 0 ? -1 : 1);
        }
    }

    public void addLevels(int par1, boolean updateXP) {
        this.experienceLevel += par1;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
        }
        if (updateXP) {
            this.experience = this.calculateLevelXP(this.experienceLevel) + this.experienceRemainder;
        }
    }

    public int thisLevelXP() {
        return this.levelXP(this.experienceLevel);
    }

    public int levelXP(int level) {
        return level >= 30 ? 62 + (level - 30) * 7 : (level >= 15 ? 17 + (level - 15) * 3 : 17);
    }

    public int calculateLevelXP(int level) {
        int levelXP = 0;
        for (int currentLevel = 1; currentLevel <= level; ++currentLevel) {
            levelXP += this.levelXP(currentLevel);
        }
        return levelXP;
    }

    public static int calculateFurnaceXP(ItemStack stack) {
        int stackSize = stack.field_77994_a;
        float xp = FurnaceRecipes.func_77602_a().getExperience(stack);
        if (xp == 0.0f) {
            return 0;
        }
        if (xp < 1.0f) {
            int result = (int)Math.floor((float)stackSize * xp);
            if (result < (int)Math.ceil((float)stackSize * xp) && (float)Math.random() < (float)stackSize * xp - (float)result) {
                ++result;
            }
            stackSize = result;
        }
        return stackSize;
    }

    private static boolean isBook(ItemStack stack) {
        return stack.field_77993_c == Item.field_77760_aL.field_77779_bT;
    }

    static {
        IXPSource.handlers.add(new FurnaceXPSource());
        IXPSource.handlers.add(new TurtleXPSource());
        IXPSource.handlers.add(new LiquidXPSource());
    }

    public static class LiquidXPSource
    implements IXPSource {
        public static final Map liquids = new HashMap();

        @Override
        public int get(ITurtleAccess turtle, int x, int y, int z, int side) {
            TileEntity te = turtle.getWorld().func_72796_p(x, y, z);
            if (!(te instanceof ITankContainer)) {
                return 0;
            }
            ITankContainer tc = (ITankContainer)te;
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            ArrayList<ILiquidTank> tanks = new ArrayList<ILiquidTank>();
            tanks.addAll(Arrays.asList(tc.getTanks(dir)));
            for (Map.Entry entry : liquids.entrySet()) {
                ILiquidTank tank = tc.getTank(dir, (LiquidStack)entry.getKey());
                if (tank == null) continue;
                tanks.add(tank);
            }
            int ret = 0;
            for (ILiquidTank tank : tanks) {
                for (Map.Entry entry : liquids.entrySet()) {
                    LiquidStack drained;
                    LiquidStack wanted = (LiquidStack)entry.getKey();
                    if (!wanted.isLiquidEqual(tank.getLiquid())) continue;
                    while ((drained = tank.drain(wanted.amount, true)) != null) {
                        ret += (int)Math.floor((float)((Integer)entry.getValue()).intValue() * ((float)drained.amount / (float)wanted.amount));
                    }
                }
            }
            return ret;
        }
    }

    public static class TurtleXPSource
    implements IXPSource {
        @Override
        public int get(ITurtleAccess turtle, int x, int y, int z, int side) {
            int levels;
            TileEntity te = turtle.getWorld().func_72796_p(x, y, z);
            if (!(te instanceof ITurtleAccess)) {
                return 0;
            }
            PeripheralXP xp = (PeripheralXP)Util.getPeripheral(turtle, PeripheralXP.class);
            if (xp != null && (levels = xp.experienceLevel) > 0) {
                xp.addLevels(-levels, true);
                return xp.calculateLevelXP(levels);
            }
            return 0;
        }
    }

    public static class FurnaceXPSource
    implements IXPSource {
        public static final Map classes = new HashMap();

        @Override
        public int get(ITurtleAccess turtle, int x, int y, int z, int side) {
            TileEntity te = turtle.getWorld().func_72796_p(x, y, z);
            if (te == null) {
                return 0;
            }
            int[] slots = null;
            for (Map.Entry entry : classes.entrySet()) {
                if (!((Class)entry.getKey()).isAssignableFrom(te.getClass())) continue;
                slots = (int[])entry.getValue();
                break;
            }
            if (slots == null) {
                return 0;
            }
            int ret = 0;
            IInventory inv = (IInventory)te;
            for (int slot : slots) {
                ItemStack stack = inv.func_70304_b(slot);
                if (stack == null) continue;
                Util.storeOrDrop(turtle, stack);
                ret += PeripheralXP.calculateFurnaceXP(stack);
            }
            return ret;
        }

        static {
            classes.put(TileEntityFurnace.class, new int[]{2});
        }
    }
}

