/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import miscperipherals.api.ISmItem;
import miscperipherals.api.ISmSender;
import miscperipherals.core.LuaManager;
import miscperipherals.tile.TilePeripheralWrapper;
import miscperipherals.util.Positionable;
import miscperipherals.util.SmallNetHelper;
import miscperipherals.util.Util;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PeripheralSmSender
implements ISmSender,
IHostedPeripheral {
    public final Positionable positionable;
    private List links = new LinkedList();

    public PeripheralSmSender(TilePeripheralWrapper tile) {
        this.positionable = new Positionable.PositionableTile(tile);
    }

    public PeripheralSmSender(ITurtleAccess turtle) {
        this.positionable = new Positionable.PositionableTurtle(turtle);
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList list = tag.func_74761_m("links");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound link = (NBTTagCompound)list.func_74743_b(i);
            this.links.add(new UUID(link.func_74763_f("msb"), link.func_74763_f("lsb")));
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (UUID uuid : this.links) {
            NBTTagCompound link = new NBTTagCompound();
            link.func_74772_a("lsb", uuid.getLeastSignificantBits());
            link.func_74772_a("msb", uuid.getMostSignificantBits());
            list.func_74742_a((NBTBase)link);
        }
        tag.func_74782_a("links", (NBTBase)list);
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        UUID uuid;
        ItemStack stack = player.func_70694_bm();
        if (stack != null && stack.func_77973_b() instanceof ISmItem) {
            uuid = ((ISmItem)stack.func_77973_b()).getUUID(player, stack);
            if (this.links.contains(uuid)) {
                this.links.remove(uuid);
                player.func_70006_a("Unlinked from item " + uuid.toString());
            } else {
                this.links.add(uuid);
                player.func_70006_a("Linked to item " + uuid.toString());
            }
        }
        if (this.links.contains(uuid = SmallNetHelper.getUUID((Entity)player))) {
            this.links.remove(uuid);
            player.func_70006_a("Unlinked from player " + uuid.toString());
        } else {
            this.links.add(uuid);
            player.func_70006_a("Linked to player " + uuid.toString());
        }
        return true;
    }

    @Override
    public Vec3 getPosition() {
        return this.positionable.getPosition().func_72441_c(0.5, 0.5, 0.5);
    }

    @Override
    public World getWorld() {
        return this.positionable.getWorld();
    }

    @Override
    public Iterable getLinks() {
        return this.links;
    }

    @Override
    public void addLink(UUID uuid) throws UnsupportedOperationException {
        this.links.add(uuid);
    }

    @Override
    public void removeLink(UUID uuid) throws UnsupportedOperationException {
        this.links.remove(uuid);
    }

    @Override
    public double getPower() {
        return 64.0;
    }

    public String getType() {
        return "smNetSender";
    }

    public String[] getMethodNames() {
        return new String[]{"send"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                String payload;
                if (arguments.length < 2) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new Exception("bad argument #1 (expected string)");
                }
                if (!(arguments[1] instanceof String)) {
                    throw new Exception("bad argument #2 (expected string)");
                }
                String type = (String)arguments[0];
                if (type.length() > 255) {
                    type = type.substring(0, 255);
                }
                if ((payload = (String)arguments[1]).length() > 255) {
                    payload = payload.substring(0, 255);
                }
                for (UUID uuid : this.links) {
                    SmallNetHelper.send(this, uuid, Util.sanitize(type, false), Util.sanitize(payload, false));
                }
                break;
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }
}

