/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import miscperipherals.core.LuaManager;
import miscperipherals.tile.TileResupplyStation;
import miscperipherals.util.Util;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Facing;
import net.minecraft.util.Vec3;

public class PeripheralResupply
implements IHostedPeripheral {
    private final ITurtleAccess turtle;
    private ChunkCoordinates link;
    private String error = "";

    public PeripheralResupply(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "resupply";
    }

    public String[] getMethodNames() {
        return new String[]{"resupply", "link", "getError"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length != 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int slot = ((Double)arguments[0]).intValue();
                if (slot < 1 || slot > this.turtle.getInventorySize()) {
                    throw new Exception("bad slot (expected 1-" + this.turtle.getInventorySize() + ")");
                }
                --slot;
                this.error = "";
                if (this.link == null) {
                    this.error = "Not linked";
                    return new Object[]{false};
                }
                TileEntity te = this.turtle.getWorld().func_72796_p(this.link.field_71574_a, this.link.field_71572_b, this.link.field_71573_c);
                if (!(te instanceof TileResupplyStation)) {
                    this.error = "Station not found";
                    return new Object[]{false};
                }
                TileResupplyStation rs = (TileResupplyStation)te;
                ItemStack curItem = this.turtle.getSlotContents(slot);
                if (curItem == null) {
                    this.error = "Cannot identify item";
                    return new Object[]{false};
                }
                int resupplyAmount = curItem.func_77976_d() - curItem.field_77994_a;
                if (resupplyAmount < 1) {
                    return new Object[]{true};
                }
                int resupplied = rs.resupply(curItem, resupplyAmount);
                if (resupplied <= 0) {
                    this.error = "Not enough items";
                    return new Object[]{false};
                }
                curItem.field_77994_a += resupplied;
                this.turtle.setSlotContents(slot, curItem);
                return new Object[]{true};
            }
            case 1: {
                Vec3 pos = this.turtle.getPosition();
                for (int i = 0; i < 6; ++i) {
                    TileEntity te = this.turtle.getWorld().func_72796_p((int)pos.field_72450_a + Facing.field_71586_b[i], (int)pos.field_72448_b + Facing.field_71587_c[i], (int)pos.field_72449_c + Facing.field_71585_d[i]);
                    if (!(te instanceof TileResupplyStation)) continue;
                    this.link = new ChunkCoordinates(te.field_70329_l, te.field_70330_m, te.field_70327_n);
                    return new Object[]{true};
                }
                return new Object[]{false};
            }
            case 2: {
                return new Object[]{this.error};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("link")) {
            this.link = Util.readChunkCoordinatesFromNBT(nbttagcompound);
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        if (this.link != null) {
            NBTTagCompound link = new NBTTagCompound();
            Util.writeChunkCoordinatesToNBT(this.link, link);
            nbttagcompound.func_74782_a("link", (NBTBase)link);
        }
    }
}

