/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.xcompwiz.mystcraft.api.MystObjects;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import cpw.mods.fml.common.network.PacketDispatcher;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.core.LuaManager;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.Module;
import miscperipherals.core.TickHandler;
import miscperipherals.network.NetworkHelper;
import miscperipherals.util.Util;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class PeripheralMystcraft
implements IHostedPeripheral {
    private final ITurtleAccess turtle;
    private int id = Integer.MIN_VALUE;

    public PeripheralMystcraft(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "mystcraft";
    }

    public String[] getMethodNames() {
        return new String[]{"useBook"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                Future callback = TickHandler.addTickCallback(this.turtle.getWorld(), new Callable(){

                    public Boolean call() {
                        ItemStack slotstack = PeripheralMystcraft.this.turtle.getSlotContents(PeripheralMystcraft.this.turtle.getSelectedSlot());
                        if (slotstack == null || !PeripheralMystcraft.this.isValidBook(slotstack) || slotstack.field_77990_d == null) {
                            MiscPeripherals.debug("Link failed due to invalid item: " + slotstack + " " + (slotstack == null ? "N/A" : slotstack.func_77973_b()) + " " + (slotstack == null ? "N/A" : slotstack.field_77990_d));
                            return false;
                        }
                        LinkInfoStack lo = new LinkInfoStack(slotstack);
                        if (PeripheralMystcraft.this.isLinkPermitted(lo)) {
                            WorldServer world = MinecraftServer.func_71276_C().func_71218_a(lo.getDimensionUID());
                            if (world == null) {
                                MiscPeripherals.debug("Link failed due to null world: " + lo.getDimensionUID());
                                return false;
                            }
                            ChunkCoordinates dest = lo.getSpawn();
                            dest.field_71572_b += 2;
                            if (Util.isPassthroughBlock((World)world, dest.field_71574_a, dest.field_71572_b, dest.field_71573_c)) {
                                int i;
                                if (!lo.getFlag("Following")) {
                                    for (i = 0; i < 6 && !PeripheralMystcraft.this.turtle.dropItemStack(slotstack, i); ++i) {
                                    }
                                    PeripheralMystcraft.this.turtle.setSlotContents(PeripheralMystcraft.this.turtle.getSelectedSlot(), null);
                                }
                                if (lo.getFlag("Disarm")) {
                                    for (i = 0; i < PeripheralMystcraft.this.turtle.getInventorySize(); ++i) {
                                        ItemStack stack = PeripheralMystcraft.this.turtle.getSlotContents(i);
                                        for (int j = 0; j < 6 && !PeripheralMystcraft.this.turtle.dropItemStack(stack, i); ++j) {
                                        }
                                        PeripheralMystcraft.this.turtle.setSlotContents(i, null);
                                    }
                                }
                                Vec3 pos = PeripheralMystcraft.this.turtle.getPosition();
                                String sound = "myst.sound.link";
                                if (lo.getFlag("Disarm")) {
                                    sound = "myst.sound.link-disarm";
                                } else if (lo.getProperty("Sound") != null) {
                                    sound = lo.getProperty("Sound");
                                } else if (lo.getFlag("Following")) {
                                    sound = "myst.sound.link-following";
                                } else if (lo.getFlag("Intra Linking")) {
                                    sound = "myst.sound.link-intra";
                                }
                                ByteArrayDataOutput os = ByteStreams.newDataOutput();
                                os.writeInt((int)pos.field_72450_a);
                                os.writeInt((int)pos.field_72448_b);
                                os.writeInt((int)pos.field_72449_c);
                                os.writeUTF(sound);
                                PacketDispatcher.sendPacketToAllAround((double)(pos.field_72450_a + 0.5), (double)(pos.field_72448_b + 0.5), (double)(pos.field_72449_c + 0.5), (double)64.0, (int)((PeripheralMystcraft)PeripheralMystcraft.this).turtle.getWorld().field_73011_w.field_76574_g, (Packet)NetworkHelper.getModulePacket((Module)MiscPeripherals.instance.modules.get("Mystcraft"), os.toByteArray()));
                                os = ByteStreams.newDataOutput();
                                os.writeInt(dest.field_71574_a);
                                os.writeInt(dest.field_71572_b);
                                os.writeInt(dest.field_71573_c);
                                os.writeUTF(sound);
                                PacketDispatcher.sendPacketToAllAround((double)((double)dest.field_71574_a + 0.5), (double)((double)dest.field_71572_b + 0.5), (double)((double)dest.field_71573_c + 0.5), (double)64.0, (int)world.field_73011_w.field_76574_g, (Packet)NetworkHelper.getModulePacket((Module)MiscPeripherals.instance.modules.get("Mystcraft"), os.toByteArray()));
                                return Util.teleportTurtleTo(PeripheralMystcraft.this.turtle, (World)world, dest.field_71574_a, dest.field_71572_b, dest.field_71573_c);
                            }
                            MiscPeripherals.debug("Link failed due to bad target " + world.func_72798_a(dest.field_71574_a, dest.field_71572_b, dest.field_71573_c));
                            return false;
                        }
                        MiscPeripherals.debug("Link failed due to not permitted");
                        return false;
                    }
                });
                return new Object[]{callback.get()};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return false;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
        this.id = computer.getID();
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    private boolean isLinkPermitted(ILinkInfo lo) {
        return lo.getFlag("Intra Linking") || lo.getDimensionUID() == this.turtle.getWorld().field_73011_w.field_76574_g;
    }

    private boolean isValidBook(ItemStack stack) {
        return stack.field_77993_c == MystObjects.linkbook.field_77779_bT || stack.field_77993_c == MystObjects.descriptive_book.field_77779_bT;
    }

    public class LinkInfoStack
    implements ILinkInfo {
        private final ItemStack stack;

        public LinkInfoStack(ItemStack stack) {
            this.stack = stack;
        }

        public String getDisplayName() {
            return this.stack.field_77990_d != null && this.stack.field_77990_d.func_74764_b("agename") ? this.stack.field_77990_d.func_74779_i("agename") : "???";
        }

        public void setDisplayName(String displayname) {
            if (this.stack.field_77990_d == null) {
                this.stack.field_77990_d = new NBTTagCompound();
            }
            this.stack.field_77990_d.func_74778_a("agename", displayname);
        }

        public int getDimensionUID() {
            return this.stack.field_77990_d != null ? (this.stack.field_77990_d.func_74764_b("AgeUID") ? this.stack.field_77990_d.func_74762_e("AgeUID") : (this.stack.field_77990_d.func_74764_b("Dimension") ? this.stack.field_77990_d.func_74762_e("Dimension") : 0)) : 0;
        }

        public void setDimensionUID(int uid) {
            if (this.stack.field_77990_d == null) {
                this.stack.field_77990_d = new NBTTagCompound();
            }
            this.stack.field_77990_d.func_74768_a("AgeUID", uid);
        }

        public ChunkCoordinates getSpawn() {
            if (this.stack.field_77990_d != null && this.stack.field_77990_d.func_74764_b("SpawnX") && this.stack.field_77990_d.func_74764_b("SpawnY") && this.stack.field_77990_d.func_74764_b("SpawnZ")) {
                return new ChunkCoordinates(this.stack.field_77990_d.func_74762_e("SpawnX"), this.stack.field_77990_d.func_74762_e("SpawnY"), this.stack.field_77990_d.func_74762_e("SpawnZ"));
            }
            return null;
        }

        public void setSpawn(ChunkCoordinates spawn) {
            if (this.stack.field_77990_d == null) {
                this.stack.field_77990_d = new NBTTagCompound();
            }
            if (spawn != null) {
                this.stack.field_77990_d.func_74768_a("SpawnX", spawn.field_71574_a);
                this.stack.field_77990_d.func_74768_a("SpawnY", spawn.field_71572_b);
                this.stack.field_77990_d.func_74768_a("SpawnZ", spawn.field_71573_c);
            }
        }

        public float getSpawnYaw() {
            return this.stack.field_77990_d != null && this.stack.field_77990_d.func_74764_b("SpawnYaw") ? this.stack.field_77990_d.func_74760_g("SpawnYaw") : 0.0f;
        }

        public void setSpawnYaw(float spawnyaw) {
            if (this.stack.field_77990_d == null) {
                this.stack.field_77990_d = new NBTTagCompound();
            }
            this.stack.field_77990_d.func_74776_a("SpawnYaw", spawnyaw);
        }

        public boolean getFlag(String flag) {
            return this.stack.field_77990_d != null && this.stack.field_77990_d.func_74764_b(flag) && this.stack.field_77990_d.func_74767_n(flag);
        }

        public void setFlag(String flag, boolean value) {
            if (this.stack.field_77990_d == null) {
                this.stack.field_77990_d = new NBTTagCompound();
            }
            this.stack.field_77990_d.func_74757_a(flag, value);
        }

        public String getProperty(String flag) {
            return this.stack.field_77990_d != null && this.stack.field_77990_d.func_74764_b(flag) ? this.stack.field_77990_d.func_74779_i(flag) : null;
        }

        public void setProperty(String flag, String value) {
            if (this.stack.field_77990_d == null) {
                this.stack.field_77990_d = new NBTTagCompound();
            }
            this.stack.field_77990_d.func_74778_a(flag, value);
        }

        public NBTTagCompound getTagCompound() {
            return this.stack.field_77990_d;
        }
    }
}

