/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.core.LuaManager;
import miscperipherals.core.TickHandler;
import miscperipherals.safe.ReflectionStore;
import miscperipherals.safe.Reflector;
import miscperipherals.util.Util;
import mods.mffs.api.IForceEnergyItems;
import mods.mffs.api.IForceEnergyStorageBlock;
import mods.mffs.api.ISwitchabel;
import mods.mffs.api.PointXYZ;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Facing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class PeripheralMFFS
implements IHostedPeripheral {
    private final ITurtleAccess turtle;
    private int id = Integer.MIN_VALUE;
    private String error;

    public PeripheralMFFS(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "mffs";
    }

    public String[] getMethodNames() {
        return new String[]{"switch", "createCard", "teleport", "teleportUp", "teleportDown", "switchUp", "switchDown", "getError"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: 
            case 5: 
            case 6: {
                final World world = this.turtle.getWorld();
                final int direction = method == 0 ? this.turtle.getFacingDir() : (method == 8 ? 1 : 0);
                Future callback = TickHandler.addTickCallback(world, new Callable(){

                    public Boolean call() {
                        ISwitchabel switchable;
                        Boolean ag;
                        MovingObjectPosition mop = Util.rayTraceBlock(PeripheralMFFS.this.turtle, direction);
                        TileEntity te = world.func_72796_p(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                        if (te instanceof ISwitchabel && (ag = (Boolean)Reflector.invoke("mods.mffs.common.SecurityHelper", "isAccessGranted", Boolean.class, te, PeripheralMFFS.this.getDummyPlayer(), world, ReflectionStore.eb, false)) != null && ag.booleanValue() && (switchable = (ISwitchabel)te).isSwitchabel() && PeripheralMFFS.this.consumeFP(1000)) {
                            switchable.toggelSwitchValue();
                            return true;
                        }
                        return false;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 1: {
                World world = this.turtle.getWorld();
                Future callback = TickHandler.addTickCallback(world, new Callable(){

                    public Boolean call() {
                        if (ReflectionStore.MFFSitemcardempty == null || ReflectionStore.MFFSItemIDCard == null) {
                            return false;
                        }
                        ItemStack slotstack = PeripheralMFFS.this.turtle.getSlotContents(PeripheralMFFS.this.turtle.getSelectedSlot());
                        if (slotstack != null && slotstack.field_77993_c == ReflectionStore.MFFSitemcardempty.field_77779_bT && PeripheralMFFS.this.consumeFP(1000)) {
                            ItemStack card = new ItemStack(ReflectionStore.MFFSItemIDCard);
                            Reflector.invoke("mods.mffs.common.item.ItemCardPersonalID", "setOwner", Object.class, card, PeripheralMFFS.this.getTurtleUsername());
                            if (--slotstack.field_77994_a <= 0) {
                                PeripheralMFFS.this.turtle.setSlotContents(PeripheralMFFS.this.turtle.getSelectedSlot(), card);
                            } else {
                                PeripheralMFFS.this.turtle.setSlotContents(PeripheralMFFS.this.turtle.getSelectedSlot(), slotstack);
                                Util.storeOrDrop(PeripheralMFFS.this.turtle, card);
                            }
                            return true;
                        }
                        return false;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 2: 
            case 3: 
            case 4: {
                final World world = this.turtle.getWorld();
                final int direction = method == 2 ? this.turtle.getFacingDir() : (method == 3 ? 1 : 0);
                Future callback = TickHandler.addTickCallback(world, new Callable(){

                    public Boolean call() {
                        if (ReflectionStore.forcefieldtransportcost == null) {
                            return false;
                        }
                        MovingObjectPosition mop = Util.rayTraceBlock(PeripheralMFFS.this.turtle, direction);
                        if (!world.func_72899_e(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) {
                            PeripheralMFFS.this.error = "Forcefield not loaded";
                            return false;
                        }
                        Object ffw = Reflector.invoke("mods.mffs.common.WorldMap", "getForceFieldWorld", Object.class, world);
                        if (ffw == null) {
                            PeripheralMFFS.this.error = "World forcefield map missing";
                            return false;
                        }
                        Object ffbs = Reflector.invoke(ffw, "getForceFieldStackMap", Object.class, new PointXYZ(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, world));
                        if (ffbs != null) {
                            int ffb = -1;
                            Integer genid = (Integer)Reflector.invoke(ffbs, "getGenratorID", Integer.class, new Object[0]);
                            Integer projid = (Integer)Reflector.invoke(ffbs, "getProjectorID", Integer.class, new Object[0]);
                            if (genid == null || projid == null) {
                                PeripheralMFFS.this.error = "No capacitor or projector ID associated with this forcefield";
                                return false;
                            }
                            Object net = Reflector.invoke("mods.mffs.common.Linkgrid", "getWorldMap", Object.class, world);
                            Map capacitorMap = (Map)Reflector.invoke(net, "getCapacitor", Map.class, new Object[0]);
                            Map projectorMap = (Map)Reflector.invoke(net, "getProjektor", Map.class, new Object[0]);
                            if (capacitorMap == null || projectorMap == null) {
                                PeripheralMFFS.this.error = "No capacitor or projector associated with this forcefield";
                                return false;
                            }
                            Object capacitor = capacitorMap.get(genid);
                            Object projector = projectorMap.get(projid);
                            Boolean active = (Boolean)Reflector.invoke(projector, "isActive", Boolean.class, new Object[0]);
                            if (active != null && active.booleanValue()) {
                                boolean pass = false;
                                Integer accessType = (Integer)Reflector.invoke(projector, "getaccesstyp", Integer.class, new Object[0]);
                                if (accessType == null) {
                                    return false;
                                }
                                switch (accessType) {
                                    case 1: {
                                        pass = true;
                                        break;
                                    }
                                    case 2: {
                                        Boolean lpass = (Boolean)Reflector.invoke("mods.mffs.common.SecurityHelper", "isAccessGranted", Boolean.class, capacitor, PeripheralMFFS.this.getDummyPlayer(), world, ReflectionStore.ffb, false);
                                        pass = lpass != null && lpass != false;
                                        break;
                                    }
                                    case 3: {
                                        Boolean lpass = (Boolean)Reflector.invoke("mods.mffs.common.SecurityHelper", "isAccessGranted", Boolean.class, projector, PeripheralMFFS.this.getDummyPlayer(), world, ReflectionStore.ffb, false);
                                        pass = lpass != null && lpass != false;
                                        break;
                                    }
                                }
                                if (pass) {
                                    int i = 0;
                                    while (ffb != 0) {
                                        Integer lffb = (Integer)Reflector.invoke(ffw, "isExistForceFieldStackMap", Integer.class, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, i, direction);
                                        if (lffb == null) {
                                            return false;
                                        }
                                        ffb = lffb;
                                        if (ffb == 0) continue;
                                        ++i;
                                    }
                                    Integer lgenid = (Integer)Reflector.invoke(ffw, "isExistForceFieldStackMap", Integer.class, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, i - 1, PeripheralMFFS.this.turtle.getFacingDir());
                                    if (lgenid != null && genid == lgenid && i >= 0 && i <= 5) {
                                        int toX = mop.field_72311_b + Facing.field_71586_b[direction] * i;
                                        int toY = mop.field_72312_c + Facing.field_71587_c[direction] * i;
                                        int toZ = mop.field_72309_d + Facing.field_71585_d[direction] * i;
                                        if (Util.isPassthroughBlock(world, toX, toY, toZ)) {
                                            if (PeripheralMFFS.this.consumeFP(ReflectionStore.forcefieldtransportcost) && Util.teleportTurtleTo(PeripheralMFFS.this.turtle, world, toX, toY, toZ)) {
                                                return true;
                                            }
                                            PeripheralMFFS.this.error = "Not enough force power or teleport failed";
                                        } else {
                                            PeripheralMFFS.this.error = "Destination obstructed or not enough force power";
                                        }
                                    } else {
                                        PeripheralMFFS.this.error = "Field too thick";
                                    }
                                } else {
                                    PeripheralMFFS.this.error = "Access denied";
                                }
                            } else {
                                PeripheralMFFS.this.error = "Projector not active";
                            }
                        } else {
                            PeripheralMFFS.this.error = "Not in front of a forcefield";
                        }
                        return false;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 7: {
                return new Object[]{this.error};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return false;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
        this.id = computer.getID();
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    private boolean consumeFP(int amount) {
        int i;
        int i2;
        int haveFP = 0;
        World world = this.turtle.getWorld();
        for (i2 = 0; i2 < 6 && haveFP < amount; ++i2) {
            MovingObjectPosition mop = Util.rayTraceBlock(this.turtle, i2);
            TileEntity te = world.func_72796_p(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            if (!(te instanceof IForceEnergyStorageBlock)) continue;
            haveFP += ((IForceEnergyStorageBlock)te).getStorageAvailablePower();
        }
        for (i2 = 0; i2 < this.turtle.getInventorySize() && haveFP < amount; ++i2) {
            ItemStack stack = this.turtle.getSlotContents(i2);
            if (stack == null || !(stack.func_77973_b() instanceof IForceEnergyItems)) continue;
            haveFP += ((IForceEnergyItems)stack.func_77973_b()).getAvailablePower(stack);
        }
        if (haveFP < amount) {
            return false;
        }
        int remain = amount;
        for (i = 0; i < 6 && remain > 0; ++i) {
            MovingObjectPosition mop = Util.rayTraceBlock(this.turtle, i);
            TileEntity te = world.func_72796_p(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            if (!(te instanceof IForceEnergyStorageBlock)) continue;
            IForceEnergyStorageBlock fesb = (IForceEnergyStorageBlock)te;
            int drain = Math.min(fesb.getStorageAvailablePower(), remain);
            fesb.consumePowerfromStorage(drain, false);
            remain -= drain;
        }
        for (i = 0; i < this.turtle.getInventorySize() && remain > 0; ++i) {
            ItemStack stack = this.turtle.getSlotContents(i);
            if (stack == null || !(stack.func_77973_b() instanceof IForceEnergyItems)) continue;
            IForceEnergyItems feitem = (IForceEnergyItems)stack.func_77973_b();
            int drain = Math.min(feitem.getAvailablePower(stack), remain);
            feitem.consumePower(stack, drain, false);
            this.turtle.setSlotContents(i, stack);
            remain -= drain;
        }
        return true;
    }

    private EntityPlayer getDummyPlayer() {
        EntityPlayer player = new EntityPlayer(this.turtle.getWorld()){

            public void func_70006_a(String var1) {
            }

            public ChunkCoordinates func_82114_b() {
                return new ChunkCoordinates(0, 0, 0);
            }

            public boolean func_70003_b(int var1, String var2) {
                return false;
            }
        };
        player.field_71092_bJ = this.getTurtleUsername();
        return player;
    }

    private String getTurtleUsername() {
        return "Turtle " + (this.id == Integer.MIN_VALUE ? "???" : "#" + this.id);
    }
}

