/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import miscperipherals.core.LuaManager;
import miscperipherals.util.Util;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.util.Vec3;

public class PeripheralInventory
implements IHostedPeripheral {
    private static final Map whitelistCache = new WeakHashMap();
    private final ITurtleAccess turtle;

    public PeripheralInventory(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "inventory";
    }

    public String[] getMethodNames() {
        return new String[]{"suck", "suckUp", "suckDown", "suckSneaky", "suckSneakyUp", "suckSneakyDown", "drop", "dropUp", "dropDown", "dropSneaky", "dropSneakyUp", "dropSneakyDown", "getItem", "getItemUp", "getItemDown"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        try {
            switch (method) {
                case 0: 
                case 1: 
                case 2: {
                    if (arguments.length < 1) {
                        throw new Exception("too few arguments");
                    }
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    int slot = (int)Math.floor((Double)arguments[0]) - 1;
                    if (slot < 0) {
                        throw new Exception("invalid slot " + (slot + 1) + " (expected 1-)");
                    }
                    int amount = Integer.MAX_VALUE;
                    if (arguments.length > 1) {
                        if (!(arguments[0] instanceof Double)) {
                            throw new Exception("bad argument #2 (expected number)");
                        }
                        amount = (int)Math.floor((Double)arguments[1]);
                    }
                    if (amount < 0) {
                        throw new Exception("invalid amount " + amount + " (expected 1-)");
                    }
                    return this.suck(method == 0 ? this.turtle.getFacingDir() : (method == 1 ? 1 : 0), slot, amount);
                }
                case 3: 
                case 4: 
                case 5: {
                    if (arguments.length < 1) {
                        throw new Exception("too few arguments");
                    }
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    int slot = (int)Math.floor((Double)arguments[0]);
                    if (slot < 0 || slot > 5) {
                        throw new Exception("invalid side " + slot + " (expected 0-5)");
                    }
                    ++slot;
                    slot *= -1;
                    int amount = Integer.MAX_VALUE;
                    if (arguments.length > 1) {
                        if (!(arguments[0] instanceof Double)) {
                            throw new Exception("bad argument #2 (expected number)");
                        }
                        amount = (int)Math.floor((Double)arguments[1]);
                    }
                    if (amount < 0) {
                        throw new Exception("invalid amount " + amount + " (expected 1-)");
                    }
                    return this.suck(method == 3 ? this.turtle.getFacingDir() : (method == 4 ? 1 : 0), slot, amount);
                }
                case 6: 
                case 7: 
                case 8: {
                    if (arguments.length < 1) {
                        throw new Exception("too few arguments");
                    }
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    int slot = (int)Math.floor((Double)arguments[0]) - 1;
                    if (slot < 0) {
                        throw new Exception("invalid slot " + (slot + 1) + " (expected 1-)");
                    }
                    int amount = Integer.MAX_VALUE;
                    if (arguments.length > 1) {
                        if (!(arguments[0] instanceof Double)) {
                            throw new Exception("bad argument #2 (expected number)");
                        }
                        amount = (int)Math.floor((Double)arguments[1]);
                    }
                    if (amount < 0) {
                        throw new Exception("invalid amount " + amount + " (expected 1-)");
                    }
                    return this.drop(method == 6 ? this.turtle.getFacingDir() : (method == 7 ? 1 : 0), slot, amount);
                }
                case 9: 
                case 10: 
                case 11: {
                    if (arguments.length < 1) {
                        throw new Exception("too few arguments");
                    }
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    int slot = (int)Math.floor((Double)arguments[0]);
                    if (slot < 0 || slot > 5) {
                        throw new Exception("invalid side " + slot + " (expected 0-5)");
                    }
                    ++slot;
                    slot *= -1;
                    int amount = Integer.MAX_VALUE;
                    if (arguments.length > 1) {
                        if (!(arguments[0] instanceof Double)) {
                            throw new Exception("bad argument #2 (expected number)");
                        }
                        amount = (int)Math.floor((Double)arguments[1]);
                    }
                    if (amount < 0) {
                        throw new Exception("invalid amount " + amount + " (expected 1-)");
                    }
                    return this.drop(method == 9 ? this.turtle.getFacingDir() : (method == 10 ? 1 : 0), slot, amount);
                }
                case 12: 
                case 13: 
                case 14: {
                    if (arguments.length < 1) {
                        throw new Exception("too few arguments");
                    }
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    int slot = (int)Math.floor((Double)arguments[0]) - 1;
                    if (slot < 0) {
                        throw new Exception("invalid slot " + (slot + 1) + " (expected 1-)");
                    }
                    IInventory inv = this.getInventory(method == 12 ? this.turtle.getFacingDir() : (method == 13 ? 1 : 0));
                    if (inv == null || slot >= inv.func_70302_i_() || !this.getWhitelist(inv).contains(slot)) {
                        return new Object[]{null, null};
                    }
                    ItemStack stack = inv.func_70301_a(slot);
                    if (stack == null) {
                        return new Object[]{null, null};
                    }
                    return new Object[]{Util.getUUID(stack), stack.field_77994_a};
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    private List getWhitelist(IInventory inv) {
        if (whitelistCache.containsKey(inv)) {
            return (List)whitelistCache.get(inv);
        }
        List ret = Util.buildInventorySlotWhitelist(inv);
        whitelistCache.put(inv, ret);
        return ret;
    }

    private TileEntity getTile(int facing) {
        Vec3 pos = this.turtle.getPosition();
        int x = (int)pos.field_72450_a + Facing.field_71586_b[facing];
        int y = (int)pos.field_72448_b + Facing.field_71587_c[facing];
        int z = (int)pos.field_72449_c + Facing.field_71585_d[facing];
        return this.turtle.getWorld().func_72899_e(x, y, z) ? this.turtle.getWorld().func_72796_p(x, y, z) : null;
    }

    private IInventory getInventory(int facing) {
        TileEntity te = this.getTile(facing);
        if (te instanceof IInventory) {
            return (IInventory)te;
        }
        return null;
    }

    private Object[] suck(int facing, int slot, int amount) throws Exception {
        int fromSlot;
        ItemStack stack;
        IInventory inv;
        ItemStack selstack;
        int selslot;
        block10: {
            block9: {
                selslot = this.turtle.getSelectedSlot();
                selstack = this.turtle.getSlotContents(selslot);
                inv = this.getInventory(facing);
                if (inv == null) {
                    return new Object[]{false};
                }
                stack = null;
                fromSlot = -1;
                if (slot < 0) break block9;
                if (slot >= inv.func_70302_i_()) {
                    return new Object[]{false};
                }
                ItemStack slotstack = inv.func_70301_a(slot);
                if (!this.getWhitelist(inv).contains(slot) || !PeripheralInventory.canExtract(inv, Util.OPPOSITE[this.turtle.getFacingDir()], slot, selstack) || selstack != null && !Util.areStacksEqual(slotstack, selstack)) break block10;
                stack = slotstack;
                fromSlot = slot;
                break block10;
            }
            int side = slot * -1 - 1;
            int[] slots = Util.getInventorySlots(inv, side);
            for (int j = 0; j < slots.length; ++j) {
                int i = slots[j];
                ItemStack slotstack = inv.func_70301_a(i);
                if (slotstack == null || selstack != null && !Util.areStacksEqual(slotstack, selstack) || !PeripheralInventory.canExtract(inv, Util.OPPOSITE[this.turtle.getFacingDir()], slot, selstack)) continue;
                stack = slotstack;
                fromSlot = i;
                break;
            }
        }
        if (stack == null || fromSlot < 0 || fromSlot >= inv.func_70302_i_()) {
            return new Object[]{false};
        }
        int toAdd = selstack == null ? stack.func_77976_d() : stack.func_77976_d() - selstack.field_77994_a;
        if ((toAdd = Math.min(Math.min(toAdd, stack.field_77994_a), amount)) < amount) {
            return new Object[]{false};
        }
        if (amount > 0) {
            toAdd = amount;
        }
        inv.func_70298_a(fromSlot, toAdd);
        ItemStack toInv = stack.func_77946_l();
        toInv.field_77994_a = toAdd;
        if (selstack != null) {
            toInv.field_77994_a += selstack.field_77994_a;
        }
        if (toInv.field_77994_a > 0) {
            this.turtle.setSlotContents(selslot, toInv);
        } else {
            this.turtle.setSlotContents(selslot, null);
        }
        return new Object[]{true};
    }

    private Object[] drop(int facing, int slot, int amount) throws Exception {
        ArrayList<Integer> toSlots;
        IInventory inv;
        ItemStack selstack;
        block11: {
            block10: {
                int selslot = this.turtle.getSelectedSlot();
                selstack = this.turtle.getSlotContents(selslot);
                if (selstack == null) {
                    return new Object[]{false};
                }
                if (amount == Integer.MAX_VALUE) {
                    amount = selstack.field_77994_a;
                }
                amount = Math.min(amount, selstack.field_77994_a);
                inv = this.getInventory(facing);
                if (inv == null) {
                    return new Object[]{false};
                }
                toSlots = new ArrayList<Integer>();
                if (slot < 0) break block10;
                if (slot >= inv.func_70302_i_()) {
                    return new Object[]{false};
                }
                ItemStack slotstack = inv.func_70301_a(slot);
                if (!this.getWhitelist(inv).contains(slot) || !PeripheralInventory.canInsert(inv, Util.OPPOSITE[this.turtle.getFacingDir()], slot, selstack) || slotstack != null && !Util.areStacksEqual(slotstack, selstack)) break block11;
                toSlots.add(slot);
                break block11;
            }
            int side = slot * -1 - 1;
            int[] slots = Util.getInventorySlots(inv, side);
            for (int j = 0; j < slots.length; ++j) {
                int i = slots[j];
                ItemStack slotstack = inv.func_70301_a(i);
                if (slotstack != null && !Util.areStacksEqual(slotstack, selstack) || !PeripheralInventory.canInsert(inv, side, i, selstack)) continue;
                toSlots.add(i);
                break;
            }
        }
        int total = 0;
        HashMap amounts = new HashMap(toSlots.size());
        for (int i = 0; i < toSlots.size(); ++i) {
            ItemStack slotstack = inv.func_70301_a(((Integer)toSlots.get(i)).intValue());
            int amountToAdd = slotstack == null ? Math.min(selstack.func_77976_d(), inv.func_70297_j_()) : Math.min(selstack.func_77976_d(), inv.func_70297_j_()) - slotstack.field_77994_a;
            amounts.put(toSlots.get(i), amountToAdd);
            total += amountToAdd;
        }
        if (total < amount) {
            return new Object[]{false};
        }
        total = amount;
        int added = 0;
        Set slots = amounts.keySet();
        for (int i = 0; i < slots.size(); ++i) {
            int add = Math.min(total, (Integer)amounts.get(toSlots.get(i)));
            total -= add;
            int slotToDrop = (Integer)toSlots.get(i);
            ItemStack stack = inv.func_70301_a(slotToDrop);
            if (stack == null) {
                stack = selstack.func_77946_l();
                stack.field_77994_a = 0;
            }
            stack.field_77994_a += add;
            added += add;
            inv.func_70299_a(slotToDrop, stack);
            if (total <= 0) break;
        }
        selstack.field_77994_a -= added;
        if (selstack.field_77994_a <= 0) {
            selstack = null;
        }
        this.turtle.setSlotContents(this.turtle.getSelectedSlot(), selstack);
        return new Object[]{true};
    }

    private static boolean canInsert(IInventory inv, int side, int slot, ItemStack stack) {
        boolean ret = inv.func_94041_b(slot, stack);
        if (inv instanceof ISidedInventory) {
            ret = ret && ((ISidedInventory)inv).func_102007_a(slot, stack, side);
        }
        return ret;
    }

    private static boolean canExtract(IInventory inv, int side, int slot, ItemStack stack) {
        return inv instanceof ISidedInventory ? ((ISidedInventory)inv).func_102008_b(slot, stack, side) : true;
    }
}

