/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.TriggerParameter;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.core.LuaManager;
import miscperipherals.core.TickHandler;
import miscperipherals.tile.TilePeripheralWrapper;
import miscperipherals.util.Positionable;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class PeripheralGateReader
implements IHostedPeripheral {
    public static final TriggerParameter DUMMY_PARAM = new TriggerParameter();
    private Positionable positionable;

    public PeripheralGateReader(ITurtleAccess turtle) {
        this.positionable = new Positionable.PositionableTurtle(turtle);
    }

    public PeripheralGateReader(TilePeripheralWrapper tile) {
        this.positionable = new Positionable.PositionableTile(tile);
    }

    public String getType() {
        return "gateReader";
    }

    public String[] getMethodNames() {
        return new String[]{"get"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                TriggerParameter param = DUMMY_PARAM;
                if (arguments.length > 0) {
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    IInventory inv = this.positionable.getInventory();
                    int slot = (int)Math.floor((Double)arguments[0]) - 1;
                    if (slot < 0 || slot >= inv.func_70302_i_()) {
                        throw new Exception("bad slot " + (slot + 1) + " (expected 1-" + inv.func_70302_i_() + ")");
                    }
                    ItemStack slotstack = inv.func_70301_a(slot - 1);
                    if (slotstack != null) {
                        ItemStack stack = slotstack.func_77946_l();
                        stack.field_77994_a = 1;
                        param = new TriggerParameter();
                        param.set(stack);
                    }
                }
                final World world = this.positionable.getWorld();
                final TriggerParameter finalParam = param;
                Future callback = TickHandler.addTickCallback(world, new Callable(){

                    public Map call() {
                        Vec3 position = PeripheralGateReader.this.positionable.getPosition();
                        HashMap<String, Boolean> triggers = new HashMap<String, Boolean>();
                        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                            int x = (int)position.field_72450_a + direction.offsetX;
                            int y = (int)position.field_72448_b + direction.offsetY;
                            int z = (int)position.field_72449_c + direction.offsetZ;
                            if (!world.func_72899_e(x, y, z)) continue;
                            TileEntity te = world.func_72796_p(x, y, z);
                            for (ITrigger trigger : ActionManager.getNeighborTriggers((Block)Block.field_71973_m[world.func_72798_a((int)position.field_72450_a + direction.offsetX, (int)position.field_72448_b + direction.offsetY, (int)position.field_72449_c + direction.offsetZ)], (TileEntity)te)) {
                                triggers.put(trigger.getDescription(), trigger.isTriggerActive(direction, te, (ITriggerParameter)finalParam));
                            }
                        }
                        return triggers;
                    }
                });
                return new Object[]{callback.get()};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }
}

