/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import miscperipherals.core.LuaManager;
import miscperipherals.core.TickHandler;
import miscperipherals.tile.TilePeripheralWrapper;
import miscperipherals.util.Positionable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PeripheralFireworks
implements IHostedPeripheral {
    private final Positionable positionable;
    private String error;

    public PeripheralFireworks(ITurtleAccess turtle) {
        this.positionable = new Positionable.PositionableTurtle(turtle);
    }

    public PeripheralFireworks(TilePeripheralWrapper tile) {
        this.positionable = new Positionable.PositionableTile(tile);
    }

    public String getType() {
        return "fireworks";
    }

    public String[] getMethodNames() {
        return new String[]{"launch", "getError"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                int j;
                int i;
                InventoryCrafting craft;
                if (arguments.length == 0) {
                    throw new Exception("too few arguments");
                }
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (int i2 = 0; i2 < arguments.length; ++i2) {
                    if (!(arguments[i2] instanceof Double)) {
                        throw new Exception("bad argument #" + (i2 + 1) + " (expected number)");
                    }
                    slots.add((int)Math.floor((Double)arguments[i2]));
                }
                IInventory inv = this.positionable.getInventory();
                if (inv == null) {
                    this.error = "No inventory";
                    return new Object[]{false};
                }
                int[] slotReferencesLeft = new int[inv.func_70302_i_()];
                Arrays.fill(slotReferencesLeft, Integer.MAX_VALUE);
                ArrayList<Integer> star = new ArrayList<Integer>();
                ArrayList<Integer> starFade = new ArrayList<Integer>();
                ArrayList<Integer> rocket = new ArrayList<Integer>();
                boolean gunpowderFound = false;
                for (int i3 = 0; i3 < slots.size(); ++i3) {
                    int slot = (Integer)slots.get(i3) - 1;
                    if (slot < 0 || slot >= inv.func_70302_i_()) {
                        this.error = "Slot out of bounds: " + (slot + 1) + " (argument " + (i3 + 1) + ")";
                        return new Object[]{false};
                    }
                    ItemStack stack = inv.func_70301_a(slot);
                    if (stack == null) continue;
                    if (slotReferencesLeft[slot] == Integer.MAX_VALUE) {
                        slotReferencesLeft[slot] = stack.field_77994_a;
                    }
                    int n = slot;
                    slotReferencesLeft[n] = slotReferencesLeft[n] - 1;
                    if (slotReferencesLeft[n] < 0) continue;
                    if (stack.field_77993_c == Item.field_77756_aW.field_77779_bT) {
                        if (gunpowderFound) {
                            star.add(slot);
                            continue;
                        }
                        starFade.add(slot);
                        continue;
                    }
                    if (stack.field_77993_c == Item.field_77677_M.field_77779_bT) {
                        gunpowderFound = true;
                        rocket.add(slot);
                        continue;
                    }
                    star.add(slot);
                }
                Container container = new Container(){

                    public boolean func_75145_c(EntityPlayer var1) {
                        return true;
                    }
                };
                final World world = this.positionable.getWorld();
                CraftingManager manager = CraftingManager.func_77594_a();
                ItemStack starRes = null;
                if (star.size() > 0) {
                    craft = new InventoryCrafting(container, star.size() + 1, 1);
                    i = 0;
                    craft.func_70299_a(i++, new ItemStack(Item.field_77677_M));
                    for (j = 0; j < star.size(); ++j) {
                        craft.func_70299_a(i++, inv.func_70301_a(((Integer)star.get(j)).intValue()));
                    }
                    starRes = manager.func_82787_a(craft, world);
                    if (starRes == null) {
                        this.error = "No star match";
                        return new Object[]{false};
                    }
                    if (starFade.size() > 0) {
                        craft = new InventoryCrafting(container, starFade.size() + 1, 1);
                        i = 0;
                        craft.func_70299_a(i++, starRes);
                        for (j = 0; j < starFade.size(); ++j) {
                            craft.func_70299_a(i++, inv.func_70301_a(((Integer)starFade.get(j)).intValue()));
                        }
                        starRes = manager.func_82787_a(craft, world);
                        if (starRes == null) {
                            this.error = "No star fade match";
                            return new Object[]{false};
                        }
                    }
                }
                craft = new InventoryCrafting(container, rocket.size() + 2, 1);
                i = 0;
                craft.func_70299_a(i++, new ItemStack(Item.field_77759_aK));
                craft.func_70299_a(i++, starRes);
                for (j = 0; j < rocket.size(); ++j) {
                    craft.func_70299_a(i++, inv.func_70301_a(((Integer)rocket.get(j)).intValue()));
                }
                ItemStack firework = manager.func_82787_a(craft, world);
                if (firework == null) {
                    this.error = "No rocket match";
                    return new Object[]{false};
                }
                for (i = 0; i < slots.size(); ++i) {
                    ItemStack stack;
                    int slot = (Integer)slots.get(i);
                    if ((stack = inv.func_70301_a(--slot)) == null) continue;
                    if (--stack.field_77994_a <= 0) {
                        stack = null;
                    }
                    inv.func_70299_a(slot, stack);
                }
                Vec3 pos = this.positionable.getPosition();
                final EntityFireworkRocket rocketEnt = new EntityFireworkRocket(world, pos.field_72450_a + 0.5, pos.field_72448_b + 1.1, pos.field_72449_c + 0.5, firework);
                TickHandler.addTickCallback(world, new Callable(){

                    public Object call() throws Exception {
                        world.func_72838_d((Entity)rocketEnt);
                        return null;
                    }
                });
                return new Object[]{true};
            }
            case 1: {
                return new Object[]{this.error};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }
}

