/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.Map;
import java.util.WeakHashMap;
import miscperipherals.api.IEnergyMeterData;
import miscperipherals.core.LuaManager;
import miscperipherals.tile.TilePeripheralWrapper;
import miscperipherals.util.Positionable;
import miscperipherals.util.Util;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Facing;
import net.minecraft.util.Vec3;

public class PeripheralEnergyMeter
implements IHostedPeripheral {
    private final Positionable positionable;
    private Map computers = new WeakHashMap();
    private int ticker = 0;
    private IEnergyMeterData source;
    private NBTTagCompound data;
    private State state = State.Idle;
    private int x;
    private int y;
    private int z;
    private int side;
    private int direction = -1;
    private Object[] arguments;

    public PeripheralEnergyMeter(ITurtleAccess turtle) {
        this.positionable = new Positionable.PositionableTurtle(turtle);
    }

    public PeripheralEnergyMeter(TilePeripheralWrapper tile) {
        this.positionable = new Positionable.PositionableTile(tile);
    }

    public String getType() {
        return "energyMeter";
    }

    public String[] getMethodNames() {
        return new String[]{"start", "startUp", "startDown", "stop", "getState"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: 
            case 1: 
            case 2: {
                if (this.state == State.Idle) {
                    this.direction = method == 1 ? 1 : (method == 2 ? 0 : -1);
                    this.state = State.Start;
                    return new Object[]{true};
                }
                return new Object[]{false};
            }
            case 3: {
                if (this.state == State.Monitoring) {
                    this.state = State.Stop;
                    return new Object[]{true};
                }
                return new Object[]{false};
            }
            case 4: {
                return new Object[]{Util.camelCase(this.state.toString().replace('_', ' '))};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
        this.computers.put(computer, true);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public void update() {
        switch (this.state) {
            case Start: {
                this.start();
                break;
            }
            case Stop: {
                this.stop();
                break;
            }
            case Monitoring: {
                if (this.source == null || this.ticker % 20 != 0) break;
                Map ret = this.source.getData(this.positionable.getWorld(), this.x, this.y, this.z, this.side, this.data, this.arguments);
                if (ret == null || ret.isEmpty()) {
                    this.stop();
                    break;
                }
                for (IComputerAccess computer : this.computers.keySet()) {
                    computer.queueEvent("energy_measure", new Object[]{ret});
                }
                break;
            }
        }
        ++this.ticker;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    private void start() {
        if (this.arguments == null) {
            this.arguments = new Object[0];
        }
        this.data = new NBTTagCompound();
        Vec3 pos = this.positionable.getPosition();
        if (this.direction < 0 || !(this.positionable instanceof Positionable.PositionableTurtle)) {
            this.direction = this.positionable.getFacing();
        }
        this.x = (int)Math.floor(pos.field_72450_a) + Facing.field_71586_b[this.direction];
        this.y = (int)Math.floor(pos.field_72448_b) + Facing.field_71587_c[this.direction];
        this.z = (int)Math.floor(pos.field_72449_c) + Facing.field_71585_d[this.direction];
        this.side = Util.OPPOSITE[this.direction];
        for (IEnergyMeterData handler : IEnergyMeterData.handlers) {
            if (!handler.canHandle(this.positionable.getWorld(), this.x, this.y, this.z, this.side, this.arguments)) continue;
            this.source = handler;
            break;
        }
        if (this.source == null) {
            this.state = State.Idle;
            return;
        }
        this.source.start(this.positionable.getWorld(), this.x, this.y, this.z, this.side, this.data, this.arguments);
        this.state = State.Monitoring;
    }

    private void stop() {
        this.source.cleanup(this.positionable.getWorld(), this.x, this.y, this.z, this.side, this.data, this.arguments);
        this.state = State.Idle;
        this.side = 0;
        this.z = 0;
        this.y = 0;
        this.x = 0;
        this.direction = -1;
        this.arguments = null;
        this.data = null;
        this.source = null;
    }

    private static enum State {
        Idle,
        Monitoring,
        Start,
        Stop;

    }
}

