/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.TurtleSide;
import java.util.Random;
import miscperipherals.peripheral.PeripheralSolar;
import miscperipherals.safe.Reflector;
import miscperipherals.upgrade.UpgradeCompactSolar;

public class PeripheralCompactSolar
extends PeripheralSolar {
    private static final Random random = new Random();
    private final int type;
    private final int prodRate;

    public PeripheralCompactSolar(ITurtleAccess turtle, TurtleSide side, int type) {
        super(turtle, side);
        this.type = type;
        Integer prodRate = (Integer)Reflector.getField("cpw.mods.compactsolars.CompactSolars", "productionRate", Integer.class);
        this.prodRate = prodRate != null ? prodRate : 1;
    }

    @Override
    boolean canUpdate() {
        return super.canUpdate() && (this.prodRate == 1 || random.nextInt(this.prodRate) == 0);
    }

    @Override
    int getProduction() {
        return UpgradeCompactSolar.OUTPUT[this.type];
    }
}

