/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import miscperipherals.core.LuaManager;
import miscperipherals.core.MiscPeripherals;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class PeripheralChunkLoader
implements IHostedPeripheral {
    private final ITurtleAccess turtle;
    private IComputerAccess computer;
    public boolean ticketCreated = false;
    private ForgeChunkManager.Ticket ticket;
    private int oldChunkX = Integer.MIN_VALUE;
    private int oldChunkZ = Integer.MIN_VALUE;
    private double oldXCoord = -2.147483648E9;
    private double oldYCoord = -2.147483648E9;
    private double oldZCoord = -2.147483648E9;

    public PeripheralChunkLoader(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "chunkLoader";
    }

    public String[] getMethodNames() {
        return new String[0];
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
        this.computer = computer;
    }

    public void detach(IComputerAccess computer) {
        this.computer = computer;
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
    }

    public void update() {
        if (!MiscPeripherals.proxy.isServer()) {
            return;
        }
        Vec3 pos = this.turtle.getPosition();
        if (pos == null) {
            MiscPeripherals.log.warning("Turtle position is null! " + this.turtle);
            return;
        }
        if (this.ticketCreated && (pos.field_72450_a != this.oldXCoord || pos.field_72448_b != this.oldYCoord || pos.field_72449_c != this.oldZCoord)) {
            if (this.ticket == null) {
                MiscPeripherals.log.warning("Null ticket when moving chunkloaded turtle " + (this.computer == null ? "[unknown]" : Integer.valueOf(this.computer.getID())) + " at (" + (int)pos.field_72450_a + "," + (int)pos.field_72448_b + "," + (int)pos.field_72449_c + ")!");
            } else {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
                this.ticketCreated = false;
                this.oldXCoord = pos.field_72450_a;
                this.oldYCoord = pos.field_72448_b;
                this.oldZCoord = pos.field_72449_c;
            }
        }
        if (!this.ticketCreated) {
            this.ticketCreated = true;
            this.ticket = ForgeChunkManager.requestTicket((Object)MiscPeripherals.instance, (World)this.turtle.getWorld(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (this.ticket == null) {
                MiscPeripherals.log.warning("Chunk loading limit exceeded, not chunkloading turtle " + (this.computer == null ? "[unknown]" : Integer.valueOf(this.computer.getID())) + " at (" + (int)pos.field_72450_a + "," + (int)pos.field_72448_b + "," + (int)pos.field_72449_c + ")!");
                return;
            }
            int width = MiscPeripherals.instance.chunkLoaderRadius * 2 + 1;
            this.ticket.setChunkListDepth(width * width);
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    private void updatePos(int x, int y, int z) {
        if (this.ticket != null) {
            NBTTagCompound modData = this.ticket.getModData();
            modData.func_74768_a("turtleX", x);
            modData.func_74768_a("turtleY", y);
            modData.func_74768_a("turtleZ", z);
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            if (this.oldChunkX != chunkX || this.oldChunkZ != chunkZ) {
                int radius = MiscPeripherals.instance.chunkLoaderRadius;
                for (int cx = chunkX - radius; cx <= chunkX + radius; ++cx) {
                    for (int cz = chunkZ - radius; cz <= chunkZ + radius; ++cz) {
                        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(cx, cz));
                    }
                }
                this.oldChunkX = chunkX;
                this.oldChunkZ = chunkZ;
            }
        }
    }
}

