/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import miscperipherals.core.LuaManager;
import miscperipherals.util.Util;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PeripheralChest
implements IHostedPeripheral {
    private final ITurtleAccess turtle;
    private final int pages;
    private IInventory inventory;
    private int curPage = 1;

    public PeripheralChest(ITurtleAccess turtle, int pages) {
        this.turtle = turtle;
        this.pages = pages;
        this.inventory = new InventoryBasic("Turtle", false, turtle.getInventorySize() * pages);
    }

    public String getType() {
        return "chest";
    }

    public String[] getMethodNames() {
        return new String[]{"swap", "swapRange", "getPages", "setPage", "getPage"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                int baseSlot = this.curPage * this.turtle.getInventorySize();
                if (arguments.length > 1) {
                    int i;
                    int[] slots = new int[arguments.length];
                    for (i = 0; i < arguments.length; ++i) {
                        if (!(arguments[i] instanceof Double)) {
                            throw new Exception("bad argument #" + (i + 1) + " (expected number)");
                        }
                        int slot = (int)Math.floor((Double)arguments[i]) - 1;
                        if (slot >= 0 && slot <= this.turtle.getInventorySize()) continue;
                        throw new Exception("bad slot " + (slot + 1) + " at argument " + (i + 1) + " (expected 1-16)");
                    }
                    for (i = 0; i < slots.length; ++i) {
                        ItemStack stack = this.inventory.func_70301_a(baseSlot + slots[i]);
                        this.inventory.func_70299_a(baseSlot + slots[i], this.turtle.getSlotContents(slots[i]));
                        this.turtle.setSlotContents(slots[i], stack);
                    }
                } else {
                    for (int i = 0; i < this.turtle.getInventorySize(); ++i) {
                        ItemStack stack = this.inventory.func_70301_a(baseSlot + i);
                        this.inventory.func_70299_a(baseSlot + i, this.turtle.getSlotContents(i));
                        this.turtle.setSlotContents(i, stack);
                    }
                }
                return new Object[0];
            }
            case 1: {
                if (arguments.length < 2) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                int start = (int)Math.floor((Double)arguments[0]) - 1;
                if (start < 0 || start > this.turtle.getInventorySize()) {
                    throw new Exception("bad start slot " + (start + 1) + " (expected 1-16)");
                }
                int end = (int)Math.floor((Double)arguments[1]) - 1;
                if (end < 0 || start > this.turtle.getInventorySize()) {
                    throw new Exception("bad end slot " + (end + 1) + " (expected 1-16)");
                }
                int baseSlot = this.curPage * this.turtle.getInventorySize();
                for (int i = Math.min(start, end); i <= Math.max(start, end); ++i) {
                    ItemStack stack = this.inventory.func_70301_a(baseSlot + i);
                    this.inventory.func_70299_a(baseSlot + i, this.turtle.getSlotContents(i));
                    this.turtle.setSlotContents(i, stack);
                }
            }
            case 2: {
                return new Object[]{this.pages};
            }
            case 3: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int page = (int)Math.floor((Double)arguments[0]);
                if (page < 1 || page > this.pages) {
                    throw new Exception("bad page " + page + " (expected 1-" + this.pages + ")");
                }
                this.curPage = page;
                return new Object[0];
            }
            case 4: {
                return new Object[]{this.curPage};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        Util.readInventoryFromNBT(this.inventory, nbttagcompound.func_74761_m("Items"));
        this.curPage = nbttagcompound.func_74762_e("curPage");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74782_a("Items", (NBTBase)Util.writeInventoryToNBT(this.inventory));
        nbttagcompound.func_74768_a("curPage", this.curPage);
    }
}

