/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.PacketDispatcher;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.Random;
import miscperipherals.core.LuaManager;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.util.Util;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PeripheralBarrel
implements IHostedPeripheral {
    public static final int TICK_RATE = 20;
    private final ITurtleAccess turtle;
    public ItemStack item;
    public int maxSize = 4096;
    private int ticker = new Random().nextInt();
    private int prevAmount = 0;
    private int prevMaxSize = this.maxSize;
    public int clientAmount = 0;

    public PeripheralBarrel(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "barrel";
    }

    public String[] getMethodNames() {
        return new String[]{"get", "put", "getItem"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                int amount;
                if (arguments.length > 0 && !(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int n = amount = arguments.length > 0 ? (int)Math.floor((Double)arguments[0]) : Integer.MAX_VALUE;
                if (this.item == null) {
                    return new Object[]{0};
                }
                ItemStack slotstack = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                if (slotstack != null && this.item != null && !this.areItemStacksEqual(slotstack, this.item)) {
                    return new Object[]{0};
                }
                int space = slotstack == null ? this.item.func_77976_d() : slotstack.func_77976_d() - slotstack.field_77994_a;
                int take = Math.min(space, Math.min(this.item.field_77994_a, amount));
                if (slotstack == null) {
                    slotstack = this.item.func_77946_l();
                    slotstack.field_77994_a = take;
                } else {
                    slotstack.field_77994_a += take;
                }
                this.item.field_77994_a -= take;
                if (this.item.field_77994_a <= 0) {
                    this.item = null;
                }
                this.turtle.setSlotContents(this.turtle.getSelectedSlot(), slotstack);
                this.updateAmount();
                return new Object[]{take};
            }
            case 1: {
                if (arguments.length > 0 && !(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int amount = arguments.length > 0 ? (int)Math.floor((Double)arguments[0]) : Integer.MAX_VALUE;
                ItemStack slotstack = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                if (slotstack == null) {
                    return new Object[]{0};
                }
                if (this.item != null && !this.areItemStacksEqual(slotstack, this.item)) {
                    return new Object[]{0};
                }
                int put = Math.min(this.maxSize - (this.item == null ? 0 : this.item.field_77994_a), Math.min(slotstack.field_77994_a, amount));
                if (this.item == null) {
                    this.item = slotstack.func_77946_l();
                } else {
                    this.item.field_77994_a += put;
                }
                slotstack.field_77994_a -= put;
                if (slotstack.field_77994_a <= 0) {
                    slotstack = null;
                }
                this.turtle.setSlotContents(this.turtle.getSelectedSlot(), slotstack);
                this.updateAmount();
                return new Object[]{put};
            }
            case 2: {
                if (this.item == null) {
                    return new Object[]{null, 0};
                }
                return new Object[]{Util.getUUID(this.item), this.item.field_77994_a};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
        if (this.item != null) {
            if (this.item.field_77994_a > this.maxSize) {
                this.item.field_77994_a = this.maxSize;
            } else if (this.item.field_77994_a == 0) {
                this.item = null;
            }
        }
        if (this.turtle.getWorld() != null && !this.turtle.getWorld().field_72995_K && ++this.ticker >= 20) {
            this.updateAmount();
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("itemID") && nbttagcompound.func_74764_b("itemSize") && nbttagcompound.func_74764_b("itemMeta")) {
            this.item = new ItemStack((int)nbttagcompound.func_74765_d("itemID"), nbttagcompound.func_74762_e("itemSize"), (int)nbttagcompound.func_74765_d("itemMeta"));
            if (nbttagcompound.func_74764_b("itemTag")) {
                this.item.field_77990_d = nbttagcompound.func_74775_l("itemTag");
            }
        } else {
            this.item = null;
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        if (this.item != null) {
            nbttagcompound.func_74777_a("itemID", (short)this.item.field_77993_c);
            nbttagcompound.func_74768_a("itemSize", this.item.field_77994_a);
            nbttagcompound.func_74777_a("itemMeta", (short)this.item.func_77960_j());
            if (this.item.field_77990_d != null) {
                nbttagcompound.func_74782_a("itemTag", (NBTBase)this.item.field_77990_d);
            }
        }
    }

    private boolean areItemStacksEqual(ItemStack a, ItemStack b) {
        if (a == null && a == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.field_77993_c == b.field_77993_c && a.func_77960_j() == b.func_77960_j() && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    private void updateAmount() {
        int amount;
        int n = amount = this.item == null ? 0 : this.item.field_77994_a;
        if (this.prevAmount != amount || this.prevMaxSize != this.maxSize) {
            World world = this.turtle.getWorld();
            Vec3 pos = this.turtle.getPosition();
            int x = (int)Math.floor(pos.field_72450_a);
            int y = (int)Math.floor(pos.field_72448_b);
            int z = (int)Math.floor(pos.field_72449_c);
            ByteArrayDataOutput os = ByteStreams.newDataOutput();
            os.writeInt(x);
            os.writeInt(y);
            os.writeInt(z);
            os.writeInt(amount);
            os.writeInt(this.maxSize);
            PacketDispatcher.sendPacketToAllAround((double)(pos.field_72450_a + 0.5), (double)(pos.field_72448_b + 0.5), (double)(pos.field_72449_c + 0.5), (double)64.0, (int)world.field_73011_w.field_76574_g, (Packet)PacketDispatcher.getTinyPacket((Object)MiscPeripherals.instance, (short)5, (byte[])os.toByteArray()));
        }
    }
}

