/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.TurtleSide;
import java.util.Random;
import miscperipherals.core.LuaManager;
import miscperipherals.peripheral.PeripheralXP;
import miscperipherals.util.FakePlayer;
import miscperipherals.util.RandomExt;
import miscperipherals.util.Util;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Facing;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PeripheralAnvil
implements IHostedPeripheral {
    public static final float DAMAGE_CHANCE = 0.12f;
    public static final int MAX_DAMAGE = 2;
    public static final int MAX_COST = 40;
    private final ITurtleAccess turtle;
    private final TurtleSide side;
    private final RandomExt random = new RandomExt();
    public int damage = 0;

    public PeripheralAnvil(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = turtle;
        this.side = side;
    }

    public String getType() {
        return "anvil";
    }

    public String[] getMethodNames() {
        return new String[]{"getRepairCost", "repair", "suicide"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 2) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                if (arguments.length > 2 && !(arguments[2] instanceof String)) {
                    throw new Exception("bad argument #3 (expected string)");
                }
                int slotA = (int)Math.floor((Double)arguments[0]);
                int slotB = (int)Math.floor((Double)arguments[1]);
                if (slotA < 1 || slotA > this.turtle.getInventorySize()) {
                    throw new Exception("bad first slot " + slotA + " (expected 1-" + this.turtle.getInventorySize() + ")");
                }
                --slotA;
                if (slotB < 1 || slotB > this.turtle.getInventorySize()) {
                    throw new Exception("bad second slot " + slotB + " (expected 1-" + this.turtle.getInventorySize() + ")");
                }
                --slotB;
                if (this.damage > 2) {
                    return new Object[]{0};
                }
                AnvilData data = this.getAnvilData(this.turtle.getSlotContents(slotA), this.turtle.getSlotContents(slotB), arguments.length > 2 ? (String)arguments[2] : "");
                return new Object[]{data.cost < 1 || data.cost >= 40 || data.stack == null ? 0 : data.cost};
            }
            case 1: {
                if (arguments.length < 2) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                if (arguments.length > 2 && !(arguments[2] instanceof String)) {
                    throw new Exception("bad argument #3 (expected string)");
                }
                int slotA = (int)Math.floor((Double)arguments[0]);
                int slotB = (int)Math.floor((Double)arguments[1]);
                if (slotA < 1 || slotA > this.turtle.getInventorySize()) {
                    throw new Exception("bad first slot " + slotA + " (expected 1-" + this.turtle.getInventorySize() + ")");
                }
                --slotA;
                if (slotB < 1 || slotB > this.turtle.getInventorySize()) {
                    throw new Exception("bad second slot " + slotB + " (expected 1-" + this.turtle.getInventorySize() + ")");
                }
                --slotB;
                if (this.damage > 2) {
                    return new Object[]{false};
                }
                PeripheralXP xp = (PeripheralXP)Util.getPeripheral(this.turtle, PeripheralXP.class);
                if (xp == null) {
                    return new Object[]{false};
                }
                AnvilData data = this.getAnvilData(this.turtle.getSlotContents(slotA), this.turtle.getSlotContents(slotB), arguments.length > 2 && arguments[2] != null ? (String)arguments[2] : "");
                if (data.cost < 1 || data.cost >= 40 || data.stack == null) {
                    return new Object[]{false};
                }
                xp.addLevels(-data.cost, true);
                this.turtle.setSlotContents(slotA, data.stack);
                this.turtle.setSlotContents(slotB, null);
                this.damage(false);
                return new Object[]{true};
            }
            case 2: {
                if (this.damage > 2) {
                    return new Object[]{false};
                }
                World world = this.turtle.getWorld();
                int facing = this.turtle.getFacingDir();
                Vec3 pos = this.turtle.getPosition();
                int x = (int)Math.floor(pos.field_72450_a);
                int y = (int)Math.floor(pos.field_72448_b);
                int z = (int)Math.floor(pos.field_72449_c);
                boolean success = false;
                int[] directions = new int[]{0, facing, Util.OPPOSITE[facing], 1};
                for (int i = 0; i < directions.length; ++i) {
                    if (!Util.isPassthroughBlock(world, x + Facing.field_71586_b[directions[i]], y + Facing.field_71587_c[directions[i]], z + Facing.field_71585_d[directions[i]]) || !world.func_72832_d(x + Facing.field_71586_b[directions[i]], y + Facing.field_71587_c[directions[i]], z + Facing.field_71585_d[directions[i]], Block.field_82510_ck.field_71990_ca, this.damage << 2, 2)) continue;
                    Block.field_82510_ck.func_71847_b(world, x + Facing.field_71586_b[directions[i]], y + Facing.field_71587_c[directions[i]], z + Facing.field_71585_d[directions[i]], (Random)this.random);
                    success = true;
                    break;
                }
                if (success) {
                    this.damage(true);
                }
                return new Object[]{success};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.damage = nbttagcompound.func_74762_e("damage");
        this.random.setSeed(nbttagcompound.func_74763_f("rndSeed"));
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("damage", this.damage);
        nbttagcompound.func_74772_a("rndSeed", this.random.getSeed());
    }

    private void damage(boolean forceBreak) {
        if (this.random.nextFloat() < 0.12f && ++this.damage > 2 || forceBreak) {
            this.damage = 3;
            Util.setTurtleUpgrade(this.turtle, this.side, null);
        }
    }

    private ContainerRepair getFakeAnvil() {
        FakePlayer player = FakePlayer.get(this.turtle.getWorld());
        player.alignToTurtle(this.turtle);
        return new ContainerRepair(player.field_71071_by, this.turtle.getWorld(), 0, 0, 0, (EntityPlayer)player);
    }

    private AnvilData getAnvilData(ItemStack a, ItemStack b, String name) {
        ContainerRepair anvil = this.getFakeAnvil();
        IInventory input = anvil.func_75139_a((int)0).field_75224_c;
        IInventory output = anvil.func_75139_a((int)2).field_75224_c;
        input.func_70299_a(0, a);
        input.func_70299_a(1, b);
        anvil.func_82850_a(name);
        return new AnvilData(anvil.field_82854_e, output.func_70301_a(0));
    }

    private static class AnvilData {
        public final int cost;
        public final ItemStack stack;

        public AnvilData(int cost, ItemStack stack) {
            this.cost = cost;
            this.stack = stack;
        }
    }
}

