/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import miscperipherals.core.LuaManager;
import miscperipherals.core.TickHandler;
import miscperipherals.tile.TilePeripheralWrapper;
import miscperipherals.util.BFMachine;
import miscperipherals.util.Positionable;
import net.minecraft.nbt.NBTTagCompound;

public class PeripheralAccelerator
implements IHostedPeripheral {
    private final Positionable positionable;
    private List alarms = new ArrayList();
    private List alarmsToRemove = new ArrayList();
    private Random rnd = new Random();

    public PeripheralAccelerator(ITurtleAccess turtle) {
        this.positionable = new Positionable.PositionableTurtle(turtle);
    }

    public PeripheralAccelerator(TilePeripheralWrapper tile) {
        this.positionable = new Positionable.PositionableTile(tile);
    }

    public String getType() {
        return "hardwareAccelerator";
    }

    public String[] getMethodNames() {
        return new String[]{"tickAlarm", "bf"};
    }

    public Object[] callMethod(final IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int ticks = (int)Math.floor((Double)arguments[0]);
                if (ticks < 1) {
                    throw new Exception("bad tick time " + ticks + " (expected 1-)");
                }
                double id = this.rnd.nextLong();
                final TickAlarm alarm = new TickAlarm(computer, ticks, id);
                TickHandler.addTickCallback(this.positionable.getWorld(), new Callable(){

                    public Object call() throws Exception {
                        PeripheralAccelerator.this.alarms.add(alarm);
                        return null;
                    }
                }).get();
                return new Object[]{id};
            }
            case 1: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new Exception("bad argument #1 (expected string)");
                }
                if (arguments.length > 1 && !(arguments[1] instanceof String)) {
                    throw new Exception("bad argument #2 (expected string)");
                }
                final double id = this.rnd.nextLong();
                BFMachine machine = new BFMachine((String)arguments[0]);
                if (arguments.length > 1) {
                    machine.setInput((String)arguments[1]);
                }
                machine.addEventHandler(new BFMachine.BFEventHandler(){

                    @Override
                    public void onOutput(String output, String add) {
                    }

                    @Override
                    public void onInsta(int value) {
                        computer.queueEvent("bf_insta", new Object[]{id, value});
                    }

                    @Override
                    public void onError(BFMachine.BFException e) {
                        computer.queueEvent("bf_error", new Object[]{id, e.getMessage()});
                    }

                    @Override
                    public void onEnd(String output) {
                        computer.queueEvent("bf_end", new Object[]{id, output});
                    }
                });
                new Thread((Runnable)machine, "MiscPeripherals BF Executor [" + computer + "]").start();
                return new Object[]{id};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
        this.alarmsToRemove.clear();
        for (TickAlarm alarm : this.alarms) {
            if (alarm.tick()) continue;
            this.alarmsToRemove.add(alarm);
        }
        this.alarms.removeAll(this.alarmsToRemove);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    private static class TickAlarm {
        private final IComputerAccess computer;
        private int ticks;
        private final double id;

        public TickAlarm(IComputerAccess computer, int ticks, double id) {
            this.computer = computer;
            this.ticks = ticks;
            this.id = id;
        }

        public boolean tick() {
            if (--this.ticks <= 0) {
                this.computer.queueEvent("tickAlarm", new Object[]{this.id});
                return false;
            }
            return true;
        }
    }
}

