/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.module;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.registry.GameRegistry;
import dan200.computer.api.ComputerCraftAPI;
import dan200.computer.api.IHostedPeripheral;
import dan200.computer.api.IPeripheralHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import miscperipherals.api.IEnergyMeterData;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.Module;
import miscperipherals.external.ExtTesseract;
import miscperipherals.safe.Reflector;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import thermalexpansion.api.item.ItemRegistry;

public class ModuleThermalExpansion
extends Module {
    @Override
    public void onPreInit() {
    }

    @Override
    public void onInit() {
    }

    @Override
    public void onPostInit() {
        if (MiscPeripherals.instance.enableChargeStation) {
            ItemStack machineFrame = ItemRegistry.getItem((String)"machineFrame", (int)1);
            ItemStack conduitEnergy = ItemRegistry.getItem((String)"conduitEnergy", (int)1);
            if (machineFrame != null && conduitEnergy != null) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)MiscPeripherals.instance.blockAlpha, 1, 0), (Object[])new Object[]{conduitEnergy, machineFrame, Item.field_77767_aC});
            }
        }
        IEnergyMeterData.handlers.add(new IEnergyMeterData(){

            @Override
            public boolean canHandle(World world, int x, int y, int z, int side, Object[] arguments) {
                if (!world.func_72899_e(x, y, z)) {
                    return false;
                }
                TileEntity te = world.func_72796_p(x, y, z);
                return te != null && te.getClass().getName().equals("thermalexpansion.block.conduit.TileConduitEnergy");
            }

            @Override
            public void start(World world, int x, int y, int z, int side, NBTTagCompound data, Object[] arguments) {
                if (!world.func_72899_e(x, y, z)) {
                    return;
                }
                TileEntity te = world.func_72796_p(x, y, z);
                if (te == null || !te.getClass().getName().equals("thermalexpansion.block.conduit.TileConduitEnergy")) {
                    return;
                }
                Reflector.setField(te, "trackEnergy", true);
                Reflector.setField(te, "energySent", new LinkedList());
            }

            @Override
            public void cleanup(World world, int x, int y, int z, int side, NBTTagCompound data, Object[] arguments) {
                if (!world.func_72899_e(x, y, z)) {
                    return;
                }
                TileEntity te = world.func_72796_p(x, y, z);
                if (te == null || !te.getClass().getName().equals("thermalexpansion.block.conduit.TileConduitEnergy")) {
                    return;
                }
                Reflector.setField(te, "trackEnergy", false);
                Reflector.setField(te, "energySent", null);
            }

            @Override
            public Map getData(World world, int x, int y, int z, int side, NBTTagCompound data, Object[] arguments) {
                if (!world.func_72899_e(x, y, z)) {
                    return null;
                }
                TileEntity te = world.func_72796_p(x, y, z);
                if (te == null || !te.getClass().getName().equals("thermalexpansion.block.conduit.TileConduitEnergy")) {
                    return null;
                }
                HashMap<String, Float> ret = new HashMap<String, Float>();
                List transfer = (List)Reflector.getField(te, "energySent", List.class);
                float total = 0.0f;
                Iterator i$ = transfer.iterator();
                while (i$.hasNext()) {
                    float tick = ((Float)i$.next()).floatValue();
                    total += tick;
                }
                ret.put("total", Float.valueOf(total));
                ret.put("average", Float.valueOf(total / (float)transfer.size()));
                Reflector.setField(te, "trackEnergy", true);
                Reflector.setField(te, "energySent", new LinkedList());
                return ret;
            }
        });
        try {
            ComputerCraftAPI.registerExternalPeripheral(Class.forName("thermalexpansion.api.tileentity.ITesseract"), (IPeripheralHandler)new IPeripheralHandler(){

                public IHostedPeripheral getPeripheral(TileEntity tile) {
                    return new ExtTesseract(tile);
                }
            });
        }
        catch (ClassNotFoundException e) {
            MiscPeripherals.log.warning("Thermal Expansion too old for tesseract interface");
        }
        OreDictionary.registerOre((String)"MiscPeripherals$energyMeter", (ItemStack)ItemRegistry.getItem((String)"multimeter", (int)1));
    }

    @Override
    public void handleNetworkMessage(NetHandler source, boolean isClient, ByteArrayDataInput data) {
    }
}

