/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.module;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import dan200.computer.api.ComputerCraftAPI;
import dan200.computer.api.IHostedPeripheral;
import dan200.computer.api.IPeripheralHandler;
import java.util.HashMap;
import java.util.Map;
import miscperipherals.api.IMinecartData;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.Module;
import miscperipherals.external.ExtTrack;
import miscperipherals.external.ExtTrackLauncher;
import miscperipherals.external.ExtTrackLimiter;
import miscperipherals.external.ExtTrackLocomotive;
import miscperipherals.external.ExtTrackPriming;
import miscperipherals.safe.Reflector;
import miscperipherals.tile.TileSignalController;
import miscperipherals.upgrade.UpgradeTank;
import miscperipherals.util.Util;
import mods.railcraft.api.tracks.ITrackInstance;
import net.minecraft.block.Block;
import net.minecraft.entity.DataWatcher;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModuleRailcraft
extends Module {
    public static boolean enableSignalController = true;

    @Override
    public void onPreInit() {
        enableSignalController = MiscPeripherals.instance.settings.get("features", "enableSignalController", enableSignalController, "Enable the Electronic Signal Controller peripheral").getBoolean(enableSignalController);
    }

    @Override
    public void onInit() {
        if (enableSignalController) {
            ItemStack receiver;
            MiscPeripherals.instance.blockAlpha.registerTile(14).setClass(TileSignalController.class).setSprites("signalBox").setName("signalController").setInfoText(MiscPeripherals.instance.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileSignalController.class, (String)"MiscPeripherals Signal Controller");
            LanguageRegistry.instance().addStringLocalization("miscperipherals.signalController.name", "Electronic Signal Controller");
            ItemStack controller = GameRegistry.findItemStack((String)"Railcraft", (String)"signal.box.controller", (int)1);
            if (controller == null) {
                controller = GameRegistry.findItemStack((String)"Railcraft", (String)"part.circuit.signal", (int)1);
            }
            if (controller == null) {
                controller = new ItemStack(Item.field_77742_bb);
            }
            if ((receiver = GameRegistry.findItemStack((String)"Railcraft", (String)"signal.box.receiver", (int)1)) == null) {
                receiver = GameRegistry.findItemStack((String)"Railcraft", (String)"part.circuit.signal", (int)1);
            }
            if (receiver == null) {
                receiver = new ItemStack(Item.field_77742_bb);
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)MiscPeripherals.instance.blockAlpha, 1, 14), new Object[]{true, "GRG", "@D#", "GRG", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('D'), Item.field_77702_n, Character.valueOf('@'), controller, Character.valueOf('#'), receiver}));
            GameRegistry.registerCustomItemStack((String)"signalController", (ItemStack)new ItemStack((Block)MiscPeripherals.instance.blockAlpha, 1, 14));
        }
    }

    @Override
    public void onPostInit() {
        ItemStack ironTankGauge;
        ItemStack worldAnchor = GameRegistry.findItemStack((String)"Railcraft", (String)"machine.alpha.world.anchor", (int)1);
        if (worldAnchor != null) {
            OreDictionary.registerOre((String)"MiscPeripherals$chunkLoader", (ItemStack)worldAnchor);
        }
        if ((ironTankGauge = GameRegistry.findItemStack((String)"Railcraft", (String)"machine.beta.tank.iron.gauge", (int)1)) != null) {
            UpgradeTank.CRAFTING_ITEM[0] = ironTankGauge;
        }
        final HashMap<String, Class> tracks = new HashMap<String, Class>();
        tracks.put("mods.railcraft.common.blocks.tracks.TrackLimiter", ExtTrackLimiter.class);
        tracks.put("mods.railcraft.common.blocks.tracks.TrackLocomotive", ExtTrackLocomotive.class);
        tracks.put("mods.railcraft.common.blocks.tracks.TrackLauncher", ExtTrackLauncher.class);
        tracks.put("mods.railcraft.common.blocks.tracks.TrackPriming", ExtTrackPriming.class);
        Class cls = Reflector.getClass("mods.railcraft.common.blocks.tracks.TileTrack");
        if (cls != null) {
            ComputerCraftAPI.registerExternalPeripheral((Class)cls, (IPeripheralHandler)new IPeripheralHandler(){

                public IHostedPeripheral getPeripheral(TileEntity tile) {
                    ITrackInstance track = (ITrackInstance)Reflector.getField(tile, "track", ITrackInstance.class);
                    Class extClass = (Class)tracks.get(track.getClass().getName());
                    if (extClass != null) {
                        try {
                            return (IHostedPeripheral)Reflector.construct(extClass, ExtTrack.class, track);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    return null;
                }
            });
        }
        IMinecartData.handlers.add(new IMinecartData(){

            @Override
            public Map getMinecartData(EntityMinecart cart) {
                HashMap<String, Object> ret = new HashMap<String, Object>();
                String className = cart.getClass().getName();
                if (className.equals("mods.railcraft.common.carts.EntityCartAnchor")) {
                    Long fuel;
                    ret.put("__CART_TYPE__", "anchor");
                    Integer refuel = (Integer)Reflector.invoke("mods.railcraft.common.core.RailcraftConfig", "anchorRefuel", Integer.class, new Object[0]);
                    if (refuel != null && refuel > 0 && (fuel = (Long)Reflector.invoke(cart, "getAnchorFuel", Long.class, new Object[0])) != null) {
                        ret.put("fuel", (double)fuel.longValue() / (72000.0 * (double)refuel.intValue()));
                    }
                } else if (className.equals("mods.railcraft.common.carts.EntityCartBasic")) {
                    ret.put("__CART_TYPE__", "basic");
                    ret.put("occupied", cart.field_70153_n != null);
                    if (cart.field_70153_n != null) {
                        ret.put("username", cart.field_70153_n.func_70023_ak());
                    }
                } else if (className.equals("mods.railcraft.common.carts.EntityCartChest")) {
                    ret.put("__CART_TYPE__", "storage");
                } else if (className.equals("mods.railcraft.common.carts.EntityCartEnergy")) {
                    Integer transferLimit;
                    ret.put("__CART_TYPE__", "energy");
                    ret.put("type", Util.camelCase(((IInventory)cart).func_70303_b().replace(" Cart", "")));
                    ret.put("energy", cart.func_70096_w().func_75679_c(20));
                    Integer capacity = (Integer)Reflector.invoke(cart, "getCapacity", Integer.class, new Object[0]);
                    if (capacity != null) {
                        ret.put("capacity", capacity);
                    }
                    if ((transferLimit = (Integer)Reflector.invoke(cart, "getTransferLimit", Integer.class, new Object[0])) != null) {
                        ret.put("transferRate", transferLimit);
                    }
                } else if (className.equals("mods.railcraft.common.carts.EntityCartFurnace")) {
                    ret.put("__CART_TYPE__", "furnace");
                    NBTTagCompound workaround = new NBTTagCompound();
                    cart.func_70109_d(workaround);
                    ret.put("fuel", workaround.func_74762_e("Fuel"));
                } else if (className.equals("mods.railcraft.common.carts.EntityCartPumpkin")) {
                    ret.put("__CART_TYPE__", "pumpkin");
                } else if (className.equals("mods.railcraft.common.carts.EntityCartGift")) {
                    ret.put("__CART_TYPE__", "gift");
                } else if (className.equals("mods.railcraft.common.carts.EntityCartTNT")) {
                    ret.put("__CART_TYPE__", "tnt");
                    ret.put("fuse", Integer.valueOf(cart.func_70096_w().func_75693_b(20)));
                } else if (className.equals("mods.railcraft.common.carts.EntityCartTank")) {
                    ret.put("__CART_TYPE__", "tank");
                    DataWatcher dw = cart.func_70096_w();
                    if (dw.func_75679_c(20) != 0) {
                        ret.put("liquid", Util.getUUID(new ItemStack(dw.func_75679_c(20), dw.func_75679_c(22), dw.func_75679_c(21))));
                        ret.put("amount", dw.func_75679_c(22));
                    }
                } else if (className.equals("mods.railcraft.common.carts.EntityCartTrackRelayer")) {
                    ret.put("__CART_TYPE__", "trackRelayer");
                } else if (className.equals("mods.railcraft.common.carts.EntityCartUndercutter")) {
                    ret.put("__CART_TYPE__", "undercutter");
                } else if (className.equals("mods.railcraft.common.carts.EntityCartWork")) {
                    ret.put("__CART_TYPE__", "work");
                } else if (className.equals("mods.railcraft.common.carts.EntityTunnelBore")) {
                    ret.put("__CART_TYPE__", "tunnelBore");
                    ItemStack head = ((IInventory)cart).func_70301_a(0);
                    if (head != null) {
                        ret.put("boreHead", Util.getUUID(head));
                        ret.put("boreHeadHealth", 1.0 - (double)head.func_77960_j() / (double)head.func_77958_k());
                    }
                } else if (className.equals("mods.railcraft.common.carts.EntityLocomotiveSteam")) {
                    ret.put("__CART_TYPE__", "locomotiveSteam");
                    DataWatcher dw = cart.func_70096_w();
                    ret.put("mode", Util.camelCase(ExtTrackLocomotive.locoModes[dw.func_75683_a(22)].toString()));
                    ret.put("speed", dw.func_75683_a(23));
                } else {
                    return null;
                }
                return ret;
            }
        });
    }

    @Override
    public void handleNetworkMessage(NetHandler source, boolean isClient, ByteArrayDataInput data) {
    }

    public static void updateTrack(ITrackInstance track) {
        Reflector.invoke(track, "sendUpdateToClient", Object.class, new Object[0]);
    }
}

